/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.resources;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.entitymanager.ResourceManager;
import com.pmease.quickbuild.model.Resource;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.BeanUtils;
import java.util.Collection;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

@Path(value="/resources")
public class ResourceResource {
    @GET
    public Collection<Resource> list() {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        return ResourceManager.instance.getAll();
    }

    @POST
    public Long save(Resource resource) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        BeanUtils.validate(resource);
        ResourceManager.instance.save(resource);
        return resource.getId();
    }

    @Path(value="/{id}")
    @GET
    public Resource get(@PathParam(value="id") Long id) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        return (Resource)ResourceManager.instance.load(id);
    }

    @Path(value="/{id}")
    @DELETE
    public void delete(@PathParam(value="id") Long id) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        ResourceManager.instance.delete(ResourceManager.instance.load(id));
    }
}

