/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.resources;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.entitymanager.GroupManager;
import com.pmease.quickbuild.entitymanager.MembershipManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.model.Membership;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.BeanUtils;
import java.util.Collection;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

@Path(value="/memberships")
public class MembershipResource {
    @GET
    public Collection<Membership> list(@QueryParam(value="user_id") Long userId, @QueryParam(value="group_id") Long groupId) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        Collection<Object> memberships = userId != null ? ((User)UserManager.instance.get(userId)).getMemberships() : (groupId != null ? ((Group)GroupManager.instance.get(groupId)).getMemberships() : MembershipManager.instance.getAll());
        return memberships;
    }

    @POST
    public Long save(Membership membership) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        BeanUtils.validate(membership);
        MembershipManager.instance.save(membership);
        return membership.getId();
    }

    @Path(value="/{id}")
    @GET
    public Membership get(@PathParam(value="id") Long id) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        return (Membership)MembershipManager.instance.load(id);
    }

    @Path(value="/{id}")
    @DELETE
    public void delete(@PathParam(value="id") Long id) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        MembershipManager.instance.delete(MembershipManager.instance.load(id));
    }
}

