/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.resources;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.SecurityHelper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang.Validate;

@Path(value="/latest_builds")
public class LatestBuildResource {
    @GET
    public List<Build> query(@QueryParam(value="parent_configuration_id") Long parentConfigurationId, @QueryParam(value="recursive") boolean recursive) {
        Build latestBuild;
        List<Configuration> children;
        ArrayList<Build> latestBuilds = new ArrayList<Build>();
        if (parentConfigurationId != null) {
            Configuration configuration = CacheManager.instance.getConfiguration(parentConfigurationId);
            Validate.notNull((Object)configuration);
            children = recursive ? CacheManager.instance.getDescendents(configuration.getId()) : CacheManager.instance.getChildren(configuration.getId());
            for (Configuration child : children) {
                latestBuild = CacheManager.instance.getLatestBuild(child.getId());
                if (latestBuild == null) continue;
                latestBuilds.add(latestBuild);
            }
        } else {
            Configuration root = CacheManager.instance.getConfiguration(Configuration.ROOT_ID);
            Validate.notNull((Object)root);
            children = recursive ? CacheManager.instance.getDescendents(root.getId()) : CacheManager.instance.getChildren(root.getId());
            children.add(root);
            for (Configuration child : children) {
                latestBuild = CacheManager.instance.getLatestBuild(child.getId());
                if (latestBuild == null) continue;
                latestBuilds.add(latestBuild);
            }
        }
        if (SecurityHelper.isAdmin()) {
            return latestBuilds;
        }
        for (Build build : latestBuilds) {
            Configuration configuration = (Configuration)ConfigurationManager.instance.load(build.getConfiguration().getId());
            if (SecurityHelper.hasPermission(configuration)) continue;
            throw new AccessDeniedException("Access denied for builds under configuration '" + configuration.getPathName() + "'.");
        }
        return latestBuilds;
    }

    @Path(value="/{configuration_id}")
    @GET
    public Build get(@PathParam(value="configuration_id") Long configurationId) {
        Build latestBuild = CacheManager.instance.getLatestBuild(configurationId);
        if (latestBuild == null) {
            return null;
        }
        if (SecurityHelper.isAdmin()) {
            return latestBuild;
        }
        Configuration configuration = (Configuration)ConfigurationManager.instance.load(latestBuild.getConfiguration().getId());
        if (!SecurityHelper.hasPermission(configuration)) {
            throw new AccessDeniedException("Access denied for builds under configuration '" + configuration.getPathName() + "'.");
        }
        return latestBuild;
    }
}

