/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.resources;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.entitymanager.GroupManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.BeanUtils;
import java.util.Collection;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

@Path(value="/groups")
public class GroupResource {
    @GET
    public Collection<Group> list() {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        return GroupManager.instance.getAll();
    }

    @POST
    public Long save(Group group) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        BeanUtils.validate(group);
        for (VersionedDocument dom : group.getPluginSettingDOMs().values()) {
            dom.validate();
        }
        GroupManager.instance.save(group);
        return group.getId();
    }

    @Path(value="/{id}")
    @GET
    public Group get(@PathParam(value="id") Long id) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        return (Group)GroupManager.instance.load(id);
    }

    @Path(value="/{id}")
    @DELETE
    public void delete(@PathParam(value="id") Long id) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        GroupManager.instance.delete(GroupManager.instance.load(id));
    }
}

