/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.resources;

import com.google.common.base.Preconditions;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.FileInfo;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.security.SecurityHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;

@Path(value="/files")
public class FileResource {
    @GET
    public List<FileInfo> list(@QueryParam(value="build_id") Long buildId, @QueryParam(value="path") String path) {
        Preconditions.checkNotNull((Object)buildId);
        Build build = (Build)BuildManager.instance.load(buildId);
        if (!SecurityHelper.hasPermission(build.getConfiguration())) {
            throw new AccessDeniedException();
        }
        if (path != null && path.contains("..")) {
            throw new QuickbuildException("Path parameter is not allowed to contain '..'");
        }
        File destFile = path != null ? new File(build.getPublishDir(), path) : build.getPublishDir();
        if (destFile.exists()) {
            ArrayList<FileInfo> files = new ArrayList<FileInfo>();
            if (destFile.isDirectory()) {
                for (File each : destFile.listFiles()) {
                    FileInfo info = new FileInfo();
                    info.setDirectory(each.isDirectory());
                    info.setLastModified(each.lastModified());
                    info.setName(each.getName());
                    info.setSize(each.length());
                    files.add(info);
                }
            } else {
                FileInfo info = new FileInfo();
                info.setDirectory(false);
                info.setLastModified(destFile.lastModified());
                info.setName(destFile.getName());
                info.setSize(destFile.length());
                files.add(info);
            }
            return files;
        }
        return null;
    }
}

