/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.resources;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.taskschedule.schedule.Schedule;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang.Validate;
import org.hibernate.Hibernate;

@Path(value="/configurations")
public class ConfigurationResource {
    @GET
    public Collection<Configuration> list(@QueryParam(value="parent_id") Long parentId, @QueryParam(value="recursive") boolean recursive) {
        List<Object> configurations;
        if (parentId != null) {
            Configuration parent = CacheManager.instance.getConfiguration(parentId);
            Validate.notNull((Object)parent);
            configurations = recursive ? CacheManager.instance.getDescendents(parent.getId()) : CacheManager.instance.getChildren(parent.getId());
        } else {
            configurations = new ArrayList<Configuration>();
            if (recursive) {
                configurations.addAll(CacheManager.instance.getConfigurations().values());
            } else {
                Configuration root = CacheManager.instance.getConfiguration(Configuration.ROOT_ID);
                Validate.notNull((Object)root);
                configurations.add(root);
            }
        }
        if (SecurityHelper.isAdmin()) {
            return configurations;
        }
        Iterator it = configurations.iterator();
        while (it.hasNext()) {
            Configuration configuration = (Configuration)ConfigurationManager.instance.load(((Configuration)it.next()).getId());
            if (SecurityHelper.hasPermission(configuration)) continue;
            it.remove();
        }
        return configurations;
    }

    private void validate(Configuration configuration) {
        BeanUtils.validate(configuration);
        for (VersionedDocument dom : configuration.getRepositoryDOMs().values()) {
            dom.validate();
        }
        for (VersionedDocument dom : configuration.getStepDOMs().values()) {
            dom.validate();
        }
        for (VersionedDocument dom : configuration.getPluginSettingDOMs().values()) {
            dom.validate();
        }
        if (configuration.getVersionManagerDOM() != null) {
            configuration.getVersionManagerDOM().validate();
        }
    }

    @POST
    public Long save(Configuration configuration) {
        if (configuration.getId() != null) {
            Configuration reloaded = (Configuration)ConfigurationManager.instance.load(configuration.getId());
            Hibernate.initialize((Object)reloaded);
            if (!SecurityHelper.hasPermission(reloaded, ConfigurationPermission.EDIT_SETTINGS.name())) {
                throw new AccessDeniedException();
            }
            if (configuration.getParent() != null) {
                HashSet<Long> traversedIds = new HashSet<Long>();
                traversedIds.add(configuration.getId());
                for (Configuration parent = (Configuration)ConfigurationManager.instance.load(configuration.getParent().getId()); parent != null; parent = parent.getParent()) {
                    if (traversedIds.contains(parent.getId())) {
                        throw new QuickbuildException("Circular parent referenced found.");
                    }
                    traversedIds.add(parent.getId());
                }
            } else if (!configuration.getId().equals(Configuration.ROOT_ID)) {
                throw new QuickbuildException("Parent configuration has to be specified for non-root configuration.");
            }
            SessionManager.getSession().evict((Object)reloaded);
        } else {
            if (configuration.getParent() == null) {
                throw new QuickbuildException("Configuration parent has to be specified.");
            }
            Configuration parent = (Configuration)ConfigurationManager.instance.load(configuration.getParent().getId());
            if (!SecurityHelper.hasPermission(parent, ConfigurationPermission.ADD_CHILDREN.name())) {
                throw new AccessDeniedException();
            }
        }
        this.validate(configuration);
        boolean isNew = configuration.isNew();
        ConfigurationManager.instance.save(configuration);
        if (isNew) {
            AuditManager.instance.audit(configuration, "Configuration was added via REST.");
        } else {
            AuditManager.instance.audit(configuration, "Configuration was modified via REST.");
        }
        return configuration.getId();
    }

    @Path(value="/{id}/copy")
    @GET
    public Long copy(@PathParam(value="id") Long id, @QueryParam(value="parent_id") Long parentId, @QueryParam(value="name") String name, @QueryParam(value="recursive") boolean recursive) {
        Configuration newConfiguration;
        Configuration configuration = (Configuration)ConfigurationManager.instance.load(id);
        if (!SecurityHelper.hasPermission(configuration, ConfigurationPermission.ACCESS_SETTINGS.name())) {
            throw new AccessDeniedException();
        }
        if (parentId != null) {
            if (configuration.getParent() != null && parentId.equals(configuration.getParent().getId()) && name == null) {
                throw new QuickbuildException("Please specify a different name of the new configuration.");
            }
            Configuration parent = (Configuration)ConfigurationManager.instance.load(parentId);
            if (!SecurityHelper.hasPermission(parent, ConfigurationPermission.ADD_CHILDREN.name())) {
                throw new AccessDeniedException();
            }
            newConfiguration = ConfigurationManager.instance.copyAsNew(configuration, recursive);
            newConfiguration.setParent(parent);
            if (name != null) {
                newConfiguration.setName(name);
            }
            this.validate(newConfiguration);
            ConfigurationManager.instance.save(newConfiguration);
            AuditManager.instance.audit(newConfiguration, "Configuration was added via REST.");
            this.saveChildren(newConfiguration);
        } else {
            if (configuration.isRoot()) {
                throw new QuickbuildException("Query parameter parent_id has to be specified to copy the root configuration.");
            }
            if (name == null) {
                throw new QuickbuildException("Please specify a different name of the new configuration.");
            }
            if (!SecurityHelper.hasPermission(configuration.getParent(), ConfigurationPermission.ADD_CHILDREN.name())) {
                throw new AccessDeniedException();
            }
            newConfiguration = ConfigurationManager.instance.copyAsNew(configuration, recursive);
            newConfiguration.setParent(configuration.getParent());
            if (name != null) {
                newConfiguration.setName(name);
            }
            this.validate(newConfiguration);
            ConfigurationManager.instance.save(newConfiguration);
            AuditManager.instance.audit(newConfiguration, "Configuration was added via REST.");
            this.saveChildren(newConfiguration);
        }
        return newConfiguration.getId();
    }

    private void saveChildren(Configuration configuration) {
        for (Configuration child : configuration.getChildren()) {
            ConfigurationManager.instance.save(child);
            AuditManager.instance.audit(child, "Configuration was added via REST.");
            this.saveChildren(child);
        }
    }

    @Path(value="/{id}")
    @GET
    public Configuration get(@PathParam(value="id") Long id) {
        Configuration configuration = (Configuration)Quickbuild.getInstance(ConfigurationManager.class).load(id);
        if (!SecurityHelper.hasPermission(configuration, ConfigurationPermission.ACCESS_SETTINGS.name())) {
            throw new AccessDeniedException();
        }
        return configuration;
    }

    @Path(value="/{id}/error_message")
    @GET
    public String getErrorMessage(@PathParam(value="id") Long id) {
        if (SecurityHelper.isAdmin()) {
            Configuration configuration = Quickbuild.getInstance(CacheManager.class).getConfiguration(id);
            Validate.notNull((Object)configuration);
            return configuration.getErrorMessage();
        }
        Configuration configuration = (Configuration)Quickbuild.getInstance(ConfigurationManager.class).load(id);
        if (!SecurityHelper.hasPermission(configuration)) {
            throw new AccessDeniedException();
        }
        return configuration.getErrorMessage();
    }

    @Path(value="/{id}/path")
    @GET
    public String getPath(@PathParam(value="id") Long id) {
        ArrayList<String> names = new ArrayList<String>();
        CacheManager cacheManager = Quickbuild.getInstance(CacheManager.class);
        Configuration current = cacheManager.getConfiguration(id);
        Validate.notNull((Object)current);
        while (true) {
            names.add(current.getName());
            if (current.getParent() == null) break;
            current = cacheManager.getConfiguration(current.getParent().getId());
            Validate.notNull((Object)current);
        }
        Collections.reverse(names);
        return StringUtils.join(names, (char)'/');
    }

    @Path(value="/{id}/name")
    @GET
    public String getName(@PathParam(value="id") Long id) {
        CacheManager cacheManager = Quickbuild.getInstance(CacheManager.class);
        Configuration configuration = cacheManager.getConfiguration(id);
        Validate.notNull((Object)configuration);
        return configuration.getName();
    }

    @Path(value="/{id}/disabled")
    @GET
    public Boolean getDisabled(@PathParam(value="id") Long id) {
        Configuration configuration = CacheManager.instance.getConfiguration(id);
        Validate.notNull((Object)configuration);
        return configuration.getDisabled();
    }

    @Path(value="/{id}/description")
    @GET
    public String getDescription(@PathParam(value="id") Long id) {
        if (SecurityHelper.isAdmin()) {
            Configuration configuration = Quickbuild.getInstance(CacheManager.class).getConfiguration(id);
            Validate.notNull((Object)configuration);
            return configuration.getDescription();
        }
        Configuration configuration = (Configuration)Quickbuild.getInstance(ConfigurationManager.class).load(id);
        if (!SecurityHelper.hasPermission(configuration)) {
            throw new AccessDeniedException();
        }
        return configuration.getDescription();
    }

    @Path(value="/{id}/schedule")
    @GET
    public Schedule getSchedule(@PathParam(value="id") Long id) {
        Configuration configuration = Quickbuild.getInstance(CacheManager.class).getConfiguration(id);
        Validate.notNull((Object)configuration);
        return configuration.getSchedule();
    }

    @Path(value="/{id}/success_rate")
    @GET
    public int getSuccessRate(@PathParam(value="id") Long id, @QueryParam(value="from_date") Date from, @QueryParam(value="to_date") Date to) {
        Configuration configuration = (Configuration)ConfigurationManager.instance.load(id);
        if (!SecurityHelper.hasPermission(configuration)) {
            throw new AccessDeniedException();
        }
        return ConfigurationManager.instance.getSuccessRate(id, from, to);
    }

    @Path(value="/{id}/average_duration")
    @GET
    public int getAverageDuration(@PathParam(value="id") Long id, @QueryParam(value="from_date") Date from, @QueryParam(value="to_date") Date to) {
        Configuration configuration = (Configuration)ConfigurationManager.instance.load(id);
        if (!SecurityHelper.hasPermission(configuration)) {
            throw new AccessDeniedException();
        }
        return ConfigurationManager.instance.getAverageDuration(id, from, to);
    }

    @Path(value="/{id}/parent")
    @GET
    public Long getParent(@PathParam(value="id") Long id) {
        Configuration configuration = Quickbuild.getInstance(CacheManager.class).getConfiguration(id);
        Validate.notNull((Object)configuration);
        if (configuration.getParent() != null) {
            return configuration.getParent().getId();
        }
        return null;
    }

    @Path(value="/{id}")
    @DELETE
    public void delete(@PathParam(value="id") Long id) {
        ConfigurationManager configurationManager = Quickbuild.getInstance(ConfigurationManager.class);
        Configuration configuration = (Configuration)configurationManager.load(id);
        if (configuration.isRoot()) {
            throw new QuickbuildException("Can not delete root configuration.");
        }
        if (!SecurityHelper.hasPermission(configuration.getParent(), ConfigurationPermission.DELETE_CHILDREN.name())) {
            throw new AccessDeniedException();
        }
        configurationManager.delete(configuration);
        AuditManager.instance.audit(configuration, "delete");
    }
}

