/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.resources;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.entitymanager.CloudProfileManager;
import com.pmease.quickbuild.model.CloudProfile;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.BeanUtils;
import java.util.Collection;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

@Path(value="/cloud_profiles")
public class CloudProfileResource {
    @GET
    public Collection<CloudProfile> list() {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        return CloudProfileManager.instance.getAll();
    }

    @POST
    public Long save(CloudProfile cloudProfile) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        BeanUtils.validate(cloudProfile);
        CloudProfileManager.instance.save(cloudProfile);
        return cloudProfile.getId();
    }

    @Path(value="/{id}")
    @GET
    public CloudProfile get(@PathParam(value="id") Long id) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        return (CloudProfile)CloudProfileManager.instance.load(id);
    }

    @Path(value="/{id}")
    @DELETE
    public void delete(@PathParam(value="id") Long id) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        CloudProfileManager.instance.delete(CloudProfileManager.instance.load(id));
    }
}

