/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.resources;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.BuildDependence;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.web.page.find.SearchBuildsOption;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.hibernate.criterion.Order;

@Path(value="/builds")
public class BuildResource {
    @GET
    public List<Build> query(@QueryParam(value="configuration_id") Long configurationId, @QueryParam(value="recursive") boolean recursive, @QueryParam(value="from_date") String fromDate, @QueryParam(value="to_date") String toDate, @QueryParam(value="version") String version, @QueryParam(value="status") String status, @QueryParam(value="user_id") Long userId, @QueryParam(value="first") int first, @QueryParam(value="count") int count) {
        SearchBuildsOption findOption = new SearchBuildsOption();
        if (userId != null) {
            findOption.setUser((User)UserManager.instance.load(userId));
        }
        if (status != null) {
            findOption.setStatus(Build.Status.valueOf(status));
        }
        if (version != null) {
            findOption.setVersion(version);
        }
        try {
            if (fromDate != null) {
                if (fromDate.indexOf(32) != -1) {
                    findOption.setFromDate(new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(fromDate));
                } else {
                    findOption.setFromDate(new SimpleDateFormat("yyyy-MM-dd").parse(fromDate));
                }
            }
            if (toDate != null) {
                if (toDate.indexOf(32) != -1) {
                    findOption.setToDate(new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(toDate));
                } else {
                    findOption.setToDate(new SimpleDateFormat("yyyy-MM-dd").parse(toDate));
                }
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        if (configurationId != null) {
            findOption.setConfiguration((Configuration)ConfigurationManager.instance.load(configurationId));
        }
        findOption.setRecursive(recursive);
        SearchCriteria criteria = new SearchCriteria(findOption.getCriterions(), new Order[]{Order.desc((String)"id")});
        if (count == 0) {
            throw new RuntimeException("Please specify number of builds to query.");
        }
        List<Build> builds = BuildManager.instance.search(criteria, first, count);
        for (Build build : builds) {
            if (SecurityHelper.hasPermission(build.getConfiguration())) continue;
            throw new AccessDeniedException("Access denied for builds under configuration '" + build.getConfiguration().getPathName() + "'.");
        }
        return builds;
    }

    @GET
    @Path(value="/count")
    public int count(@QueryParam(value="configuration_id") Long configurationId, @QueryParam(value="recursive") boolean recursive, @QueryParam(value="from_date") String fromDate, @QueryParam(value="to_date") String toDate, @QueryParam(value="version") String version, @QueryParam(value="status") String status, @QueryParam(value="user_id") Long userId) {
        SearchBuildsOption findOption = new SearchBuildsOption();
        if (userId != null) {
            findOption.setUser((User)UserManager.instance.load(userId));
        }
        if (status != null) {
            findOption.setStatus(Build.Status.valueOf(status));
        }
        if (version != null) {
            findOption.setVersion(version);
        }
        try {
            if (fromDate != null) {
                if (fromDate.indexOf(32) != -1) {
                    findOption.setFromDate(new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(fromDate));
                } else {
                    findOption.setFromDate(new SimpleDateFormat("yyyy-MM-dd").parse(fromDate));
                }
            }
            if (toDate != null) {
                if (toDate.indexOf(32) != -1) {
                    findOption.setToDate(new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(toDate));
                } else {
                    findOption.setToDate(new SimpleDateFormat("yyyy-MM-dd").parse(toDate));
                }
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        if (configurationId != null) {
            findOption.setConfiguration((Configuration)ConfigurationManager.instance.load(configurationId));
        }
        findOption.setRecursive(recursive);
        SearchCriteria criteria = new SearchCriteria(findOption.getCriterions());
        return BuildManager.instance.count(criteria);
    }

    @POST
    public Long save(Build build) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        Configuration configuration = (Configuration)ConfigurationManager.instance.load(build.getConfiguration().getId());
        String previousAuditContent = null;
        BeanUtils.validate(build);
        if (build.getId() != null) {
            Build existing = (Build)BuildManager.instance.load(build.getId());
            previousAuditContent = VersionedDocument.fromBean(existing).toXML();
            if (!existing.getConfiguration().getId().equals(configuration.getId())) {
                BuildManager.instance.move(existing, build.getConfiguration());
            }
            SessionManager.getSession().evict((Object)existing);
        }
        BuildManager.instance.save(build);
        if (previousAuditContent != null) {
            AuditManager.instance.audit(configuration, "Build " + build.getVersion() + " (#" + build.getId() + ") was modified via REST.", VersionedDocument.fromBean(build).toXML(), previousAuditContent);
        } else {
            AuditManager.instance.audit(configuration, "Build " + build.getVersion() + " (#" + build.getId() + ") was added via REST");
        }
        return build.getId();
    }

    @Path(value="/{id}")
    @GET
    public Build get(@PathParam(value="id") Long id) {
        Build build = BuildEngine.instance.getBuild(id);
        if (build == null) {
            build = (Build)BuildManager.instance.load(id);
        }
        if (!SecurityHelper.hasPermission(build.getConfiguration())) {
            throw new AccessDeniedException();
        }
        return build;
    }

    @Path(value="/{id}")
    @DELETE
    public void delete(@PathParam(value="id") Long id) {
        Build build = (Build)BuildManager.instance.load(id);
        if (!SecurityHelper.hasPermission(build.getConfiguration(), ConfigurationPermission.DELETE_BUILD.name())) {
            throw new AccessDeniedException();
        }
        BuildManager.instance.delete(build);
        AuditManager.instance.audit(build.getConfiguration(), "Build " + build.getVersion() + " (#" + build.getId() + ") was deleted via REST.", null, null);
    }

    @Path(value="/{id}/status")
    @GET
    public Build.Status getStatus(@PathParam(value="id") Long id) {
        Build build = (Build)BuildManager.instance.load(id);
        if (!SecurityHelper.hasPermission(build.getConfiguration())) {
            throw new AccessDeniedException();
        }
        return build.getStatus();
    }

    @Path(value="/{id}/begin_date")
    @GET
    public Date getBeginDate(@PathParam(value="id") Long id) {
        Build build = (Build)BuildManager.instance.load(id);
        if (!SecurityHelper.hasPermission(build.getConfiguration())) {
            throw new AccessDeniedException();
        }
        return build.getBeginDate();
    }

    @Path(value="/{id}/duration")
    @GET
    public Long getDuration(@PathParam(value="id") Long id) {
        Build build = (Build)BuildManager.instance.load(id);
        if (!SecurityHelper.hasPermission(build.getConfiguration())) {
            throw new AccessDeniedException();
        }
        return build.getDuration();
    }

    @Path(value="/{id}/version")
    @GET
    public String getVersion(@PathParam(value="id") Long id) {
        Build build = (Build)BuildManager.instance.load(id);
        if (!SecurityHelper.hasPermission(build.getConfiguration())) {
            throw new AccessDeniedException();
        }
        return build.getVersion();
    }

    @Path(value="/{id}/request_id")
    @GET
    public String getRequestId(@PathParam(value="id") Long id) {
        Build build = (Build)BuildManager.instance.load(id);
        if (!SecurityHelper.hasPermission(build.getConfiguration())) {
            throw new AccessDeniedException();
        }
        BuildEngine buildEngine = Quickbuild.getInstance(BuildEngine.class);
        for (BuildRequest request : buildEngine.getBuildRequests(build.getConfiguration().getId())) {
            if (!id.equals(request.getBuild().getId())) continue;
            return request.getId();
        }
        return null;
    }

    @Path(value="/{id}/repositories")
    @GET
    public Collection<Repository> listRepositories(@PathParam(value="id") Long id) {
        Build build = (Build)BuildManager.instance.load(id);
        if (!SecurityHelper.hasPermission(build.getConfiguration(), ConfigurationPermission.ACCESS_SETTINGS.name())) {
            throw new AccessDeniedException();
        }
        return new ArrayList<Repository>(build.getRepositories());
    }

    @Path(value="/{id}/steps")
    @GET
    public Collection<Step> listSteps(@PathParam(value="id") Long id) {
        Build build = BuildEngine.instance.getBuild(id);
        if (build == null) {
            build = (Build)BuildManager.instance.load(id);
        }
        if (!SecurityHelper.hasPermission(build.getConfiguration(), ConfigurationPermission.ACCESS_SETTINGS.name())) {
            throw new AccessDeniedException();
        }
        return build.getSteps();
    }

    @Path(value="/{id}/stepRuntimes")
    @GET
    public Map<String, StepRuntime> listStepRuntimes(@PathParam(value="id") Long id) {
        Build build = BuildEngine.instance.getBuild(id);
        if (build == null) {
            build = (Build)BuildManager.instance.load(id);
        }
        if (!SecurityHelper.hasPermission(build.getConfiguration(), ConfigurationPermission.ACCESS_SETTINGS.name())) {
            throw new AccessDeniedException();
        }
        return new HashMap<String, StepRuntime>(build.getStepRuntimes());
    }

    @Path(value="/{id}/promotedTo")
    @GET
    public List<Build> listPromotedTo(@PathParam(value="id") Long id) {
        Build build = (Build)BuildManager.instance.load(id);
        if (!SecurityHelper.hasPermission(build.getConfiguration(), ConfigurationPermission.ACCESS_SETTINGS.name())) {
            throw new AccessDeniedException();
        }
        ArrayList<Build> promotedTo = new ArrayList<Build>();
        for (Build each : build.getPromotedTo()) {
            if (!SecurityHelper.hasPermission(each.getConfiguration())) {
                throw new AccessDeniedException("Access denied for builds under configuration '" + each.getConfiguration().getPathName() + "'.");
            }
            promotedTo.add(each);
        }
        return promotedTo;
    }

    @Path(value="/{id}/dependencies")
    @GET
    public List<Build> listDependencies(@PathParam(value="id") Long id) {
        Build build = (Build)BuildManager.instance.load(id);
        if (!SecurityHelper.hasPermission(build.getConfiguration(), ConfigurationPermission.ACCESS_SETTINGS.name())) {
            throw new AccessDeniedException();
        }
        ArrayList<Build> dependencies = new ArrayList<Build>();
        for (BuildDependence each : build.getDependencies()) {
            if (!SecurityHelper.hasPermission(each.getDependency().getConfiguration())) {
                throw new AccessDeniedException("Access denied for builds under configuration '" + each.getDependency().getConfiguration().getPathName() + "'.");
            }
            dependencies.add(each.getDependency());
        }
        return dependencies;
    }

    @Path(value="/{id}/dependents")
    @GET
    public List<Build> listDependents(@PathParam(value="id") Long id) {
        Build build = (Build)BuildManager.instance.load(id);
        if (!SecurityHelper.hasPermission(build.getConfiguration(), ConfigurationPermission.ACCESS_SETTINGS.name())) {
            throw new AccessDeniedException();
        }
        ArrayList<Build> dependents = new ArrayList<Build>();
        for (BuildDependence each : build.getDependents()) {
            if (!SecurityHelper.hasPermission(each.getDependent().getConfiguration())) {
                throw new AccessDeniedException("Access denied for builds under configuration '" + each.getDependent().getConfiguration().getPathName() + "'.");
            }
            dependents.add(each.getDependent());
        }
        return dependents;
    }
}

