/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.resources;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.FileDelivery;
import com.pmease.quickbuild.PromoteServer;
import com.pmease.quickbuild.PromotionSource;
import com.pmease.quickbuild.RequestResult;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.variable.PromptAsPasswordInput;
import com.pmease.quickbuild.variable.SecretValueProvider;
import com.pmease.quickbuild.variable.Variable;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

@Path(value="build_requests")
public class BuildRequestResource {
    @Path(value="/sample")
    @GET
    public BuildRequest getSample() {
        BuildRequest request = new BuildRequest();
        request.setConfigurationId(10L);
        PromotionSource source = new PromotionSource();
        source.setServer(new PromoteServer());
        source.getServer().setUrl("http://another-qb-server:8810");
        source.getServer().setUserName("admin");
        source.getServer().setPassword("admin");
        source.setPromotionName("release");
        source.setBuildId(697L);
        FileDelivery delivery = new FileDelivery();
        delivery.setSrcPath("artifacts/dir1");
        delivery.setFilePatterns("**/*.jar");
        source.getDeliveries().add(delivery);
        delivery = new FileDelivery();
        delivery.setSrcPath("artifacts/dir2");
        delivery.setFilePatterns("**/*.war");
        source.getDeliveries().add(delivery);
        request.setPromotionSource(source);
        request.setRespectBuildCondition(false);
        request.getVariables().put("var_name1", "var_value1");
        request.getVariables().put("var_name2", "var_value2");
        return request;
    }

    @GET
    public List<BuildRequest> query(@QueryParam(value="configuration_id") Long configurationId, @QueryParam(value="trigger_user_id") Long triggerUserId) {
        List<BuildRequest> requests = BuildEngine.instance.getBuildRequests(configurationId, triggerUserId);
        for (BuildRequest request : requests) {
            request.setBuild(null);
            Configuration configuration = (Configuration)ConfigurationManager.instance.load(request.getConfigurationId());
            if (!SecurityHelper.hasPermission(configuration)) {
                throw new AccessDeniedException("Access denied for build requests under configuration '" + configuration.getPathName() + "'.");
            }
            if (SecurityHelper.isAdmin()) continue;
            for (Map.Entry<String, String> entry : request.getVariables().entrySet()) {
                Variable var = configuration.findVar(entry.getKey());
                if (var == null || !(var.getValueProvider() instanceof SecretValueProvider) && !(var.getPromptSetting() instanceof PromptAsPasswordInput)) continue;
                entry.setValue("*****");
            }
        }
        return requests;
    }

    @POST
    public RequestResult save(BuildRequest request) {
        Configuration configuration = (Configuration)ConfigurationManager.instance.load(request.getConfigurationId());
        if (!SecurityHelper.hasPermission(configuration, ConfigurationPermission.RUN_BUILD.name())) {
            throw new AccessDeniedException();
        }
        if (request.getRequesterId() != null && !SecurityHelper.isAdmin()) {
            throw new AccessDeniedException("Only administrator can request build under another account!");
        }
        RequestResult result = BuildEngine.instance.requestBuild(Context.getUser(), false, request);
        if (configuration.findAuditBuildRequest().booleanValue()) {
            AuditManager.instance.audit(configuration, "Build was requested via REST.");
        }
        return result;
    }

    @Path(value="/{id}")
    @DELETE
    public void delete(@PathParam(value="id") String id) {
        for (BuildRequest request : BuildEngine.instance.getBuildRequests(null)) {
            if (!id.equals(request.getId())) continue;
            Configuration configuration = (Configuration)ConfigurationManager.instance.load(request.getConfigurationId());
            if (!SecurityHelper.hasPermission(configuration, ConfigurationPermission.STOP_BUILD.name())) {
                throw new AccessDeniedException();
            }
            BuildEngine.instance.cancelRequest(id);
            AuditManager.instance.audit(configuration, "Build request was cancelled via REST.");
            break;
        }
    }
}

