/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.resources;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.RunningStepInfo;
import com.pmease.quickbuild.entitymanager.TokenManager;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.UnauthorizedAgent;
import com.pmease.quickbuild.model.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

@Path(value="/buildagents")
public class BuildAgentResource {
    @Path(value="/active")
    @GET
    public List<GridNode> getActiveBuildAgents() {
        ArrayList<GridNode> actives = new ArrayList<GridNode>();
        for (GridNode each : AgentManager.instance.getBuildAgents()) {
            GridNode node = new GridNode(each.getId(), each.getIp(), each.getPort(), each.isOverSSL());
            node.setBenchmark(each.getBenchmark());
            node.setHostName(each.getHostName());
            node.setIsServer(each.isServer());
            node.setCharacteristics(null);
            node.setLastPulse(each.getLastPulse());
            actives.add(node);
        }
        return actives;
    }

    @Path(value="/inactive")
    @GET
    public List<Token> getInactiveBuildAgents() {
        List<Token> tokens = TokenManager.instance.getAll();
        HashSet<String> activeTokens = new HashSet<String>();
        for (GridNode each : AgentManager.instance.getBuildAgents()) {
            activeTokens.add(each.getToken());
        }
        Iterator it = tokens.iterator();
        while (it.hasNext()) {
            Token token = (Token)it.next();
            if (activeTokens.contains(token.getValue())) {
                it.remove();
                continue;
            }
            token.setValue(null);
        }
        return tokens;
    }

    @Path(value="/unauthorized")
    @GET
    public List<UnauthorizedAgent> getUnauthorizedBuildAgents() {
        return AgentManager.instance.getUnauthorizedAgents();
    }

    @Path(value="/{nodeAddress}/running_steps")
    @GET
    public Collection<RunningStepInfo> getRunningSteps(@PathParam(value="nodeAddress") String nodeAddress) {
        return BuildEngine.instance.getRunningSteps(nodeAddress);
    }
}

