/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.resources;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.DataManager;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.web.page.administration.BackupNowOption;
import java.io.File;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;

@Path(value="/backup")
public class BackupResource {
    @Path(value="/sample")
    @GET
    public BackupNowOption getSample() {
        BackupNowOption backupNowOption = new BackupNowOption();
        backupNowOption.setBackupTo("/path/to/backup.zip");
        return backupNowOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    public String backup(BackupNowOption backupNowOption) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        File backupFile = new File(backupNowOption.getBackupTo());
        if (!backupFile.isAbsolute()) {
            backupFile = new File(Bootstrap.installDir, backupNowOption.getBackupTo());
        }
        if (backupFile.isDirectory()) {
            throw new QuickbuildException("Please specify a file instead of a directory.");
        }
        if (!backupFile.getParentFile().exists()) {
            throw new QuickbuildException("Unable to create backup file since parent directory does not exist: " + backupFile.getParent());
        }
        try {
            FileUtils.touchFile(backupFile);
        }
        catch (Exception e) {
            throw new QuickbuildException("Can not write to backup file. Please make sure the user running QuickBuild process has write permission to the file.", (Throwable)e);
        }
        File tempDir = FileUtils.createTempDir("backup");
        try {
            DataManager.instance.exportData(tempDir, backupNowOption.isExcludeBuilds(), backupNowOption.isExcludeMeasurements(), backupNowOption.isExcludeAudits(), backupNowOption.isClearPasswords());
            FileUtils.zip(tempDir, backupFile);
            AuditManager.instance.audit("Administration::Database Backup", "Database was backed up.");
        }
        finally {
            FileUtils.deleteDir(tempDir);
        }
        return backupFile.getAbsolutePath();
    }
}

