/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.resources;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.AuthorizationManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.entitymanager.GroupManager;
import com.pmease.quickbuild.model.Authorization;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.BeanUtils;
import java.util.Collection;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

@Path(value="/authorizations")
public class AuthorizationResource {
    @GET
    public Collection<Authorization> list(@QueryParam(value="configuration_id") Long configurationId, @QueryParam(value="group_id") Long groupId) {
        Collection<Authorization> authorizations;
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        if (configurationId != null) {
            authorizations = ((Configuration)ConfigurationManager.instance.get(configurationId)).getAuthorizations();
        } else if (groupId != null) {
            authorizations = ((Group)GroupManager.instance.get(groupId)).getAuthorizations();
        } else {
            AuthorizationManager authorizationManager = Quickbuild.getInstance(AuthorizationManager.class);
            authorizations = authorizationManager.getAll();
        }
        return authorizations;
    }

    @POST
    public Long save(Authorization authorization) {
        BeanUtils.validate(authorization);
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        Quickbuild.getInstance(AuthorizationManager.class).save(authorization);
        return authorization.getId();
    }

    @Path(value="/{id}")
    @GET
    public Authorization get(@PathParam(value="id") Long id) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        return (Authorization)Quickbuild.getInstance(AuthorizationManager.class).load(id);
    }

    @Path(value="/{id}")
    @DELETE
    public void delete(@PathParam(value="id") Long id) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        Authorization authorization = (Authorization)AuthorizationManager.instance.load(id);
        AuthorizationManager.instance.delete(authorization);
    }
}

