/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.resources;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.SearchCriteria;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.model.Audit;
import com.pmease.quickbuild.security.SecurityHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;

@Path(value="/audits")
public class AuditLogResource {
    @GET
    public List<Audit> query(@QueryParam(value="username") String userName, @QueryParam(value="source") String source, @QueryParam(value="action") String action, @QueryParam(value="since") String since, @QueryParam(value="until") String until, @QueryParam(value="first") int first, @QueryParam(value="count") int count) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        ArrayList<SimpleExpression> criterions = new ArrayList<SimpleExpression>();
        if (userName != null) {
            criterions.add(Restrictions.eq((String)"user", (Object)userName));
        }
        if (source != null) {
            if (source.indexOf(42) != -1) {
                criterions.add(Restrictions.like((String)"source", (Object)source.replace('*', '%')));
            } else {
                criterions.add(Restrictions.eq((String)"source", (Object)source));
            }
        }
        if (action != null) {
            criterions.add(Restrictions.eq((String)"action", (Object)action));
        }
        try {
            if (since != null) {
                if (since.indexOf(32) != -1) {
                    criterions.add(Restrictions.ge((String)"timestamp", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(since)));
                } else {
                    criterions.add(Restrictions.ge((String)"timestamp", (Object)new SimpleDateFormat("yyyy-MM-dd").parse(since)));
                }
            }
            if (until != null) {
                if (until.indexOf(32) != -1) {
                    criterions.add(Restrictions.le((String)"timestamp", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(until)));
                } else {
                    criterions.add(Restrictions.le((String)"timestamp", (Object)new SimpleDateFormat("yyyy-MM-dd").parse(until)));
                }
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        SearchCriteria criteria = new SearchCriteria(criterions.toArray(new Criterion[0]), new Order[]{Order.desc((String)"timestamp")});
        if (count == 0) {
            throw new RuntimeException("Please specify number of audits to query.");
        }
        return AuditManager.instance.search(criteria, first, count);
    }

    @GET
    @Path(value="/count")
    public int count(@QueryParam(value="username") String userName, @QueryParam(value="source") String source, @QueryParam(value="action") String action, @QueryParam(value="since") String since, @QueryParam(value="until") String until) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        ArrayList<SimpleExpression> criterions = new ArrayList<SimpleExpression>();
        if (userName != null) {
            criterions.add(Restrictions.eq((String)"user", (Object)userName));
        }
        if (source != null) {
            if (source.indexOf(42) != -1) {
                criterions.add(Restrictions.like((String)"source", (Object)source.replace('*', '%')));
            } else {
                criterions.add(Restrictions.eq((String)"source", (Object)source));
            }
        }
        if (action != null) {
            criterions.add(Restrictions.eq((String)"action", (Object)action));
        }
        try {
            if (since != null) {
                if (since.indexOf(32) != -1) {
                    criterions.add(Restrictions.ge((String)"timestamp", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(since)));
                } else {
                    criterions.add(Restrictions.ge((String)"timestamp", (Object)new SimpleDateFormat("yyyy-MM-dd").parse(since)));
                }
            }
            if (until != null) {
                if (until.indexOf(32) != -1) {
                    criterions.add(Restrictions.le((String)"timestamp", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(until)));
                } else {
                    criterions.add(Restrictions.le((String)"timestamp", (Object)new SimpleDateFormat("yyyy-MM-dd").parse(until)));
                }
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        SearchCriteria criteria = new SearchCriteria(criterions.toArray(new Criterion[0]));
        return AuditManager.instance.count(criteria);
    }
}

