/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.providers;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.sun.jersey.core.provider.AbstractMessageReaderWriterProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.Dom4JWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

@Produces(value={"application/xml"})
@Consumes(value={"*/*"})
@Provider
public class XmlProvider
extends AbstractMessageReaderWriterProvider<Object> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return XmlProvider.isApplicable(type);
    }

    public static boolean isApplicable(Class<?> type) {
        return !type.isPrimitive() && !type.isEnum() && type != Long.class && type != Date.class && type != Integer.class && type != Boolean.class && type != Float.class && type != Double.class && type != Byte.class && type != String.class && type != Short.class && type != Character.class;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return VersionedDocument.xstream.fromXML((Reader)new InputStreamReader(entityStream));
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return XmlProvider.isApplicable(type) && mediaType != MediaType.APPLICATION_JSON_TYPE;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Document dom = DocumentHelper.createDocument();
        VersionedDocument.xstream.marshal(t, (HierarchicalStreamWriter)new Dom4JWriter((Branch)dom));
        if (!Context.isBackend() && !SecurityHelper.isAdmin()) {
            for (Node node : dom.selectNodes("//*[@secret]")) {
                Element element = (Element)node;
                element.addAttribute("secret", "mask");
                element.setText("*****");
            }
        }
        try {
            OutputFormat format = new OutputFormat();
            format.setEncoding("UTF-8");
            format.setIndent(true);
            format.setNewlines(true);
            new XMLWriter(entityStream, format).write(dom);
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }
}

