/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.providers;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.rest.providers.XmlProvider;
import com.sun.jersey.core.provider.AbstractMessageReaderWriterProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;

@Produces(value={"text/plain"})
@Consumes(value={"*/*"})
@Provider
public class PlainProvider
extends AbstractMessageReaderWriterProvider<Object> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !XmlProvider.isApplicable(type);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(entityStream));
        String text = reader.readLine();
        Class<Object> rawType = type;
        if (type.isEnum()) {
            return Enum.valueOf(rawType, text);
        }
        if (rawType == Date.class) {
            return new Date(Long.valueOf(text));
        }
        if (rawType == String.class) {
            return text;
        }
        if (rawType == Integer.TYPE || rawType == Integer.class) {
            return Integer.valueOf(text);
        }
        if (rawType == Long.TYPE || rawType == Long.class) {
            return Long.valueOf(text);
        }
        if (rawType == Boolean.TYPE || rawType == Boolean.class) {
            return Boolean.valueOf(text);
        }
        if (rawType == Byte.TYPE || rawType == Byte.class) {
            return Byte.valueOf(text);
        }
        if (rawType == Short.TYPE || rawType == Short.class) {
            return Short.valueOf(text);
        }
        if (rawType == Float.TYPE || rawType == Float.class) {
            return Float.valueOf(text);
        }
        if (rawType == Double.TYPE || rawType == Double.class) {
            return Double.valueOf(text);
        }
        if (rawType == Character.TYPE || rawType == Character.class) {
            return Character.valueOf(text.charAt(0));
        }
        throw new QuickbuildException("Unrecognized type: " + rawType.getName());
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !XmlProvider.isApplicable(type);
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (t instanceof Date) {
            entityStream.write(String.valueOf(((Date)t).getTime()).getBytes("UTF-8"));
        } else {
            entityStream.write(t.toString().getBytes("UTF-8"));
        }
    }
}

