/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.providers;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.google.common.collect.ImmutableList;
import com.pmease.quickbuild.rest.json.ObjectMapperFactory;
import com.pmease.quickbuild.rest.validation.InvalidEntityException;
import com.pmease.quickbuild.rest.validation.Validated;
import com.pmease.quickbuild.rest.validation.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.validation.Valid;
import javax.validation.groups.Default;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;

@Provider
public class JacksonMessageBodyProvider
extends JacksonJaxbJsonProvider {
    private static final Class<?>[] DEFAULT_GROUP_ARRAY = new Class[]{Default.class};
    private final ObjectMapper mapper = new ObjectMapperFactory().build();
    private final Validator validator = new Validator();

    public JacksonMessageBodyProvider() {
        this.setMapper(this.mapper);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isProvidable(type) && super.isReadable(type, genericType, annotations, mediaType);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        return this.validate(annotations, super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream));
    }

    private Object validate(Annotation[] annotations, Object value) {
        ImmutableList<String> errors;
        Class<?>[] classes = this.findValidationGroups(annotations);
        if (classes != null && !(errors = this.validator.validate(value, classes)).isEmpty()) {
            throw new InvalidEntityException("The request entity had the following errors:", (Iterable<String>)errors);
        }
        return value;
    }

    private Class<?>[] findValidationGroups(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() == Valid.class) {
                return DEFAULT_GROUP_ARRAY;
            }
            if (annotation.annotationType() != Validated.class) continue;
            return ((Validated)annotation).value();
        }
        return null;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isProvidable(type) && mediaType == MediaType.APPLICATION_JSON_TYPE;
    }

    private boolean isProvidable(Class<?> type) {
        JsonIgnoreType ignore = type.getAnnotation(JsonIgnoreType.class);
        return ignore == null || !ignore.value();
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }
}

