/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.providers;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class AccessDeniedExceptionMapper
implements ExceptionMapper<AccessDeniedException> {
    private static final Logger logger = LoggerFactory.getLogger(AccessDeniedExceptionMapper.class);

    public Response toResponse(AccessDeniedException exception) {
        logger.error("Access denied when accessing restful service.", (Throwable)exception);
        if (Context.getUser() == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"QuickBuild\"").type("text/plain").build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)exception.getMessage()).type("text/plain").build();
    }
}

