/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pmease.quickbuild.rest.json.AnnotationSensitivePropertyNamingStrategy;
import com.pmease.quickbuild.rest.json.GuavaExtrasModule;
import java.text.DateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class ObjectMapperFactory {
    private final List<Module> modules = Lists.newArrayList();
    private final Map<MapperFeature, Boolean> mapperFeatures = Maps.newHashMap();
    private final Map<DeserializationFeature, Boolean> deserializationFeatures = Maps.newHashMap();
    private final Map<SerializationFeature, Boolean> serializationFeatures = Maps.newHashMap();
    private final Map<JsonGenerator.Feature, Boolean> generatorFeatures = Maps.newHashMap();
    private final Map<JsonParser.Feature, Boolean> parserFeatures = Maps.newHashMap();
    private final Map<JsonFactory.Feature, Boolean> factoryFeatures = Maps.newHashMap();
    private final Map<PropertyAccessor, JsonAutoDetect.Visibility> visibilityRules = Maps.newLinkedHashMap();
    private AnnotationIntrospector annotationIntrospector;
    private DateFormat dateFormat;
    private PropertyNamingStrategy propertyNamingStrategy = new AnnotationSensitivePropertyNamingStrategy();
    private TypeResolverBuilder<?> defaultTyping;
    private FilterProvider filters;
    private HandlerInstantiator handlerInstantiator;
    private InjectableValues injectableValues;
    private Locale locale;
    private Map<Class<?>, Class<?>> mixinAnnotations;
    private JsonNodeFactory nodeFactory;
    private JsonInclude.Include serializationInclusion;
    private SerializerFactory serializerFactory;
    private DefaultSerializerProvider serializerProvider;
    private SubtypeResolver subtypeResolver;
    private TimeZone timeZone;
    private TypeFactory typeFactory;
    private VisibilityChecker<?> visibilityChecker;

    public ObjectMapperFactory() {
        this.enable(JsonParser.Feature.ALLOW_COMMENTS);
        this.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.registerModule((Module)new GuavaModule());
        this.registerModule(new GuavaExtrasModule());
        this.registerModule((Module)new JodaModule());
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this.annotationIntrospector;
    }

    public void setAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        this.annotationIntrospector = annotationIntrospector;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public TypeResolverBuilder<?> getDefaultTyping() {
        return this.defaultTyping;
    }

    public void setDefaultTyping(TypeResolverBuilder<?> defaultTyping) {
        this.defaultTyping = defaultTyping;
    }

    public FilterProvider getFilters() {
        return this.filters;
    }

    public void setFilters(FilterProvider filters) {
        this.filters = filters;
    }

    public HandlerInstantiator getHandlerInstantiator() {
        return this.handlerInstantiator;
    }

    public void setHandlerInstantiator(HandlerInstantiator handlerInstantiator) {
        this.handlerInstantiator = handlerInstantiator;
    }

    public InjectableValues getInjectableValues() {
        return this.injectableValues;
    }

    public void setInjectableValues(InjectableValues injectableValues) {
        this.injectableValues = injectableValues;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Map<Class<?>, Class<?>> getMixinAnnotations() {
        return this.mixinAnnotations;
    }

    public void setMixinAnnotations(Map<Class<?>, Class<?>> mixinAnnotations) {
        this.mixinAnnotations = mixinAnnotations;
    }

    public JsonNodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public void setNodeFactory(JsonNodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public PropertyNamingStrategy getPropertyNamingStrategy() {
        return this.propertyNamingStrategy;
    }

    public void setPropertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        this.propertyNamingStrategy = propertyNamingStrategy;
    }

    public JsonInclude.Include getSerializationInclusion() {
        return this.serializationInclusion;
    }

    public void setSerializationInclusion(JsonInclude.Include serializationInclusion) {
        this.serializationInclusion = serializationInclusion;
    }

    public SerializerFactory getSerializerFactory() {
        return this.serializerFactory;
    }

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this.serializerFactory = serializerFactory;
    }

    public DefaultSerializerProvider getSerializerProvider() {
        return this.serializerProvider;
    }

    public void setSerializerProvider(DefaultSerializerProvider serializerProvider) {
        this.serializerProvider = serializerProvider;
    }

    public SubtypeResolver getSubtypeResolver() {
        return this.subtypeResolver;
    }

    public void setSubtypeResolver(SubtypeResolver subtypeResolver) {
        this.subtypeResolver = subtypeResolver;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public void setTypeFactory(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public JsonAutoDetect.Visibility getVisibility(PropertyAccessor accessor) {
        return this.visibilityRules.get(accessor);
    }

    public void setVisibilityRules(PropertyAccessor accessor, JsonAutoDetect.Visibility visibility) {
        this.visibilityRules.put(accessor, visibility);
    }

    public VisibilityChecker<?> getVisibilityChecker() {
        return this.visibilityChecker;
    }

    public void setVisibilityChecker(VisibilityChecker<?> visibilityChecker) {
        this.visibilityChecker = visibilityChecker;
    }

    public void registerModule(Module module) {
        this.modules.add(module);
    }

    public boolean isEnabled(MapperFeature feature) {
        Boolean enabled = this.mapperFeatures.get(feature);
        if (enabled != null) {
            return enabled;
        }
        return feature.enabledByDefault();
    }

    public void enable(MapperFeature ... features) {
        for (MapperFeature feature : features) {
            this.mapperFeatures.put(feature, Boolean.TRUE);
        }
    }

    public void disable(MapperFeature ... features) {
        for (MapperFeature feature : features) {
            this.mapperFeatures.put(feature, Boolean.FALSE);
        }
    }

    public boolean isEnabled(DeserializationFeature feature) {
        Boolean enabled = this.deserializationFeatures.get(feature);
        if (enabled != null) {
            return enabled;
        }
        return feature.enabledByDefault();
    }

    public void enable(DeserializationFeature ... features) {
        for (DeserializationFeature feature : features) {
            this.deserializationFeatures.put(feature, Boolean.TRUE);
        }
    }

    public void disable(DeserializationFeature ... features) {
        for (DeserializationFeature feature : features) {
            this.deserializationFeatures.put(feature, Boolean.FALSE);
        }
    }

    public boolean isEnabled(SerializationFeature feature) {
        Boolean enabled = this.serializationFeatures.get(feature);
        if (enabled != null) {
            return enabled;
        }
        return feature.enabledByDefault();
    }

    public void enable(SerializationFeature ... features) {
        for (SerializationFeature feature : features) {
            this.serializationFeatures.put(feature, Boolean.TRUE);
        }
    }

    public void disable(SerializationFeature ... features) {
        for (SerializationFeature feature : features) {
            this.serializationFeatures.put(feature, Boolean.FALSE);
        }
    }

    public boolean isEnabled(JsonGenerator.Feature feature) {
        Boolean enabled = this.generatorFeatures.get(feature);
        if (enabled != null) {
            return enabled;
        }
        return feature.enabledByDefault();
    }

    public void enable(JsonGenerator.Feature ... features) {
        for (JsonGenerator.Feature feature : features) {
            this.generatorFeatures.put(feature, Boolean.TRUE);
        }
    }

    public void disable(JsonGenerator.Feature ... features) {
        for (JsonGenerator.Feature feature : features) {
            this.generatorFeatures.put(feature, Boolean.FALSE);
        }
    }

    public boolean isEnabled(JsonParser.Feature feature) {
        Boolean enabled = this.parserFeatures.get(feature);
        if (enabled != null) {
            return enabled;
        }
        return feature.enabledByDefault();
    }

    public void enable(JsonParser.Feature ... features) {
        for (JsonParser.Feature feature : features) {
            this.parserFeatures.put(feature, Boolean.TRUE);
        }
    }

    public void disable(JsonParser.Feature ... features) {
        for (JsonParser.Feature feature : features) {
            this.parserFeatures.put(feature, Boolean.FALSE);
        }
    }

    public boolean isEnabled(JsonFactory.Feature feature) {
        Boolean enabled = this.factoryFeatures.get(feature);
        if (enabled != null) {
            return enabled;
        }
        return feature.enabledByDefault();
    }

    public void enable(JsonFactory.Feature ... features) {
        for (JsonFactory.Feature feature : features) {
            this.factoryFeatures.put(feature, Boolean.TRUE);
        }
    }

    public void disable(JsonFactory.Feature ... features) {
        for (JsonFactory.Feature feature : features) {
            this.factoryFeatures.put(feature, Boolean.FALSE);
        }
    }

    public ObjectMapper build(JsonFactory factory) {
        ObjectMapper mapper = new ObjectMapper(factory);
        for (Module module : this.modules) {
            mapper.registerModule(module);
        }
        for (Map.Entry entry : this.mapperFeatures.entrySet()) {
            mapper.configure((MapperFeature)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
        }
        for (Map.Entry entry : this.deserializationFeatures.entrySet()) {
            mapper.configure((DeserializationFeature)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
        }
        for (Map.Entry entry : this.serializationFeatures.entrySet()) {
            mapper.configure((SerializationFeature)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
        }
        for (Map.Entry entry : this.generatorFeatures.entrySet()) {
            mapper.getFactory().configure((JsonGenerator.Feature)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
        }
        for (Map.Entry entry : this.parserFeatures.entrySet()) {
            mapper.getFactory().configure((JsonParser.Feature)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
        }
        for (Map.Entry entry : this.factoryFeatures.entrySet()) {
            mapper.getFactory().configure((JsonFactory.Feature)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
        }
        if (this.annotationIntrospector != null) {
            mapper.setAnnotationIntrospector(this.annotationIntrospector);
        }
        if (this.dateFormat != null) {
            mapper.setDateFormat(this.dateFormat);
        }
        if (this.defaultTyping != null) {
            mapper.setDefaultTyping(this.defaultTyping);
        }
        if (this.filters != null) {
            mapper.setFilters(this.filters);
        }
        if (this.handlerInstantiator != null) {
            mapper.setHandlerInstantiator(this.handlerInstantiator);
        }
        if (this.injectableValues != null) {
            mapper.setInjectableValues(this.injectableValues);
        }
        if (this.locale != null) {
            mapper.setLocale(this.locale);
        }
        if (this.mixinAnnotations != null) {
            mapper.setMixInAnnotations(this.mixinAnnotations);
        }
        if (this.nodeFactory != null) {
            mapper.setNodeFactory(this.nodeFactory);
        }
        if (this.propertyNamingStrategy != null) {
            mapper.setPropertyNamingStrategy(this.propertyNamingStrategy);
        }
        if (this.serializationInclusion != null) {
            mapper.setSerializationInclusion(this.serializationInclusion);
        }
        if (this.serializerFactory != null) {
            mapper.setSerializerFactory(this.serializerFactory);
        }
        if (this.serializerProvider != null) {
            mapper.setSerializerProvider(this.serializerProvider);
        }
        if (this.subtypeResolver != null) {
            mapper.setSubtypeResolver(this.subtypeResolver);
        }
        if (this.timeZone != null) {
            mapper.setTimeZone(this.timeZone);
        }
        if (this.typeFactory != null) {
            mapper.setTypeFactory(this.typeFactory);
        }
        for (Map.Entry entry : this.visibilityRules.entrySet()) {
            mapper.setVisibility((PropertyAccessor)entry.getKey(), (JsonAutoDetect.Visibility)entry.getValue());
        }
        if (this.visibilityChecker != null) {
            mapper.setVisibilityChecker(this.visibilityChecker);
        }
        return mapper;
    }

    public ObjectMapper build() {
        return this.build(new JsonFactory());
    }

    public ObjectMapperFactory copy() {
        ObjectMapperFactory factory = new ObjectMapperFactory();
        factory.modules.addAll(this.modules);
        factory.mapperFeatures.putAll(this.mapperFeatures);
        factory.deserializationFeatures.putAll(this.deserializationFeatures);
        factory.serializationFeatures.putAll(this.serializationFeatures);
        factory.generatorFeatures.putAll(this.generatorFeatures);
        factory.parserFeatures.putAll(this.parserFeatures);
        factory.factoryFeatures.putAll(this.factoryFeatures);
        factory.visibilityRules.putAll(this.visibilityRules);
        factory.annotationIntrospector = this.annotationIntrospector;
        factory.dateFormat = this.dateFormat;
        factory.defaultTyping = this.defaultTyping;
        factory.filters = this.filters;
        factory.handlerInstantiator = this.handlerInstantiator;
        factory.injectableValues = this.injectableValues;
        factory.locale = this.locale;
        factory.mixinAnnotations = this.mixinAnnotations;
        factory.nodeFactory = this.nodeFactory;
        factory.propertyNamingStrategy = this.propertyNamingStrategy;
        factory.serializationInclusion = this.serializationInclusion;
        factory.serializerFactory = this.serializerFactory;
        factory.serializerProvider = this.serializerProvider;
        factory.subtypeResolver = this.subtypeResolver;
        factory.timeZone = this.timeZone;
        factory.visibilityChecker = this.visibilityChecker;
        return factory;
    }
}

