/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.net.HostAndPort;
import java.io.IOException;

public class GuavaExtrasModule
extends Module {
    public String getModuleName() {
        return "guava-extras";
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public void setupModule(Module.SetupContext context) {
        context.addDeserializers((Deserializers)new GuavaExtrasDeserializers());
    }

    private static class GuavaExtrasDeserializers
    extends Deserializers.Base {
        private GuavaExtrasDeserializers() {
        }

        public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
            if (CacheBuilderSpec.class.isAssignableFrom(type.getRawClass())) {
                return new CacheBuilderSpecDeserializer();
            }
            if (HostAndPort.class.isAssignableFrom(type.getRawClass())) {
                return new HostAndPortDeserializer();
            }
            return super.findBeanDeserializer(type, config, beanDesc);
        }
    }

    private static class CacheBuilderSpecDeserializer
    extends JsonDeserializer<CacheBuilderSpec> {
        private CacheBuilderSpecDeserializer() {
        }

        public CacheBuilderSpec deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            String text = jp.getText();
            if ("off".equalsIgnoreCase(text) || "disabled".equalsIgnoreCase(text)) {
                return CacheBuilderSpec.disableCaching();
            }
            return CacheBuilderSpec.parse((String)text);
        }
    }

    private static class HostAndPortDeserializer
    extends JsonDeserializer<HostAndPort> {
        private HostAndPortDeserializer() {
        }

        public HostAndPort deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return HostAndPort.fromString((String)jp.getText());
        }
    }
}

