/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.AuthenticationException;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.MetricsManager;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.security.SecurityHelper;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RestServlet
extends ServletContainer {
    private boolean inited;

    public void init() throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RestServlet restServlet = this;
        synchronized (restServlet) {
            if (!this.inited) {
                super.init();
                this.inited = true;
            }
        }
        long time = System.currentTimeMillis();
        SessionManager.openSession();
        try {
            Context.setUser(SecurityHelper.authenticate(request, response));
            if (Context.getUser() == null && !SecurityHelper.isAnonymousEnabled()) {
                response.setStatus(401);
                response.setHeader("WWW-Authenticate", "Basic realm=\"QuickBuild\"");
                response.setContentType("text/plain");
            } else {
                if (!SecurityHelper.isRestAccessAllowed(Context.getUser())) {
                    throw new AccessDeniedException("Sorry, you are not allowed to access the system via RESTful API.");
                }
                super.service(request, response);
            }
        }
        catch (AuthenticationException e) {
            response.sendError(401, e.getMessage());
            Context.getLogger().trace("Error accessing RESTful service.", (Throwable)e);
        }
        finally {
            Context.setUser(null);
            SessionManager.closeSession();
            MetricsManager.instance.restRequestProcessed(System.currentTimeMillis() - time);
        }
    }
}

