/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.extensionpoint.RestResourceContribution;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.rest.HTTPDigestAuthFilter;
import com.pmease.quickbuild.util.ClassUtils;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;

public class RestModule
extends Application {
    private static Client client;

    public Set<Class<?>> getClasses() {
        HashSet classes = new HashSet();
        for (Class<?> each : ClassUtils.findImplementations(Object.class, RestModule.class)) {
            if (each.getAnnotation(Path.class) == null && each.getAnnotation(Provider.class) == null) continue;
            classes.add(each);
        }
        PluginManager pluginManager = Quickbuild.getInstance(PluginManager.class);
        for (RestResourceContribution contrib : pluginManager.getExtensions(RestResourceContribution.class, false)) {
            Set<Class<?>> contribClasses = contrib.getResourceClasses();
            if (contribClasses == null) continue;
            classes.addAll(contribClasses);
        }
        return classes;
    }

    public static synchronized Client getClient() {
        if (client == null) {
            DefaultClientConfig config = new DefaultClientConfig();
            for (Class<?> each : ClassUtils.findImplementations(Object.class, RestModule.class)) {
                if (each.getAnnotation(Provider.class) == null) continue;
                config.getClasses().add(each);
            }
            client = Client.create((ClientConfig)config);
            client.setChunkedEncodingSize(Integer.valueOf(65536));
            client.setConnectTimeout(Integer.valueOf(120000));
            client.setReadTimeout(Integer.valueOf(300000));
        }
        return client;
    }

    public static WebResource resource(String url, String userName, String password) {
        return RestModule.resource(url, userName, password, false);
    }

    public static WebResource resource(String url, String userName, String password, boolean digestAuth) {
        WebResource resource = RestModule.getClient().resource(url);
        if (userName != null) {
            if (digestAuth) {
                resource.addFilter((ClientFilter)new HTTPDigestAuthFilter(userName, password != null ? password : ""));
            } else {
                resource.addFilter((ClientFilter)new HTTPBasicAuthFilter(userName, password != null ? password : ""));
            }
        }
        return resource;
    }

    public static WebResource resource(String urlBase, String path, String userName, String password) {
        WebResource resource = RestModule.getClient().resource(UriBuilder.fromPath((String)urlBase).path(path).build(new Object[0]));
        if (userName != null) {
            resource.addFilter((ClientFilter)new HTTPBasicAuthFilter(userName, password != null ? password : ""));
        }
        return resource;
    }
}

