/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.resource.nodeselection;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.resource.nodeselection.NodeSelection;
import com.pmease.quickbuild.resource.nodeselection.NodeSelectionCriteria;
import java.util.List;
import javax.validation.constraints.Size;

@Editable(name="Nodes matching all specified criterias", order=210)
public class AndSelection
implements NodeSelection {
    private static final long serialVersionUID = 1L;
    private List<NodeSelectionCriteria> criterias;

    @Editable
    @Size(min=2, max=100)
    public List<NodeSelectionCriteria> getCriterias() {
        return this.criterias;
    }

    public void setCriterias(List<NodeSelectionCriteria> criterias) {
        this.criterias = criterias;
    }

    @Override
    public boolean matches(GridNode node) {
        for (NodeSelectionCriteria each : this.getCriterias()) {
            if (each.getCriteria().matches(node)) continue;
            return false;
        }
        return true;
    }
}

