/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.resource;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Script;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.model.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;

public class ResourceRequirement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String resourceName;
    private String condition = "true";

    @Editable(order=100)
    @NotEmpty
    @ChoiceProvider(value="getAvailableResourceNames")
    @Scriptable
    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    private static List<String> getAvailableResourceNames() {
        ArrayList<String> availableResourceNames = new ArrayList<String>();
        for (Resource resource : CacheManager.instance.getResources()) {
            availableResourceNames.add(resource.getName());
        }
        return availableResourceNames;
    }

    @Editable(order=200)
    @Scriptable
    @Script
    @Expressions(value={"always", "true", "never", "false"})
    @NotEmpty
    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }
}

