/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.resource;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.grid.GridJob;
import com.pmease.quickbuild.resource.ResourceAllocation;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.variable.VariableWrapper;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class ResourceAllocateJob
extends GridJob {
    private static final long serialVersionUID = 1L;
    private Long buildId;
    private Map<String, VariableWrapper> vars;
    private StepPath stepPath;
    private ResourceAllocation resourceAllocation;

    public ResourceAllocateJob(String taskId, Long buildId, Map<String, VariableWrapper> vars, StepPath stepPath) {
        super(taskId);
        this.buildId = buildId;
        this.vars = vars;
        this.stepPath = stepPath;
    }

    @Override
    protected void execute() {
        Validate.isTrue((boolean)Bootstrap.isServer());
        this.resourceAllocation = BuildEngine.instance.allocateResource(this.buildId, this.vars, this.stepPath);
    }

    public Long getBuildId() {
        return this.buildId;
    }

    public Map<String, VariableWrapper> getVars() {
        return this.vars;
    }

    public ResourceAllocation getResourceAllocation() {
        return this.resourceAllocation;
    }
}

