/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.repositorysupport;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.repositorysupport.Revision;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import java.io.Serializable;
import java.util.List;

public class WorkingDirLocator<T extends Revision>
extends SourceViewSupport<T> {
    private SourceViewSupport<T> sourceViewSupport;

    public WorkingDirLocator(SourceViewSupport<T> sourceViewSupport) {
        super(sourceViewSupport.getRepository());
        this.sourceViewSupport = sourceViewSupport;
    }

    @Override
    public String getRepositoryPath(String checkoutPath) {
        Build build = this.sourceViewSupport.getRepository().getBuild();
        GridNode node = build.getMasterStep().getNode();
        if (node == null) {
            throw new QuickbuildException("Can not locate node '" + build.getMasterStep().getNodeAddress() + "' to read source from. " + "The host name might has been changed recently.");
        }
        return (String)((Object)node.executeJob(SourceViewJob.class, new Serializable[]{this.sourceViewSupport, "getRepositoryPath", checkoutPath}));
    }

    @Override
    public List<String> readSourceByRevision(String repositoryPath, T revision) {
        Build build = this.sourceViewSupport.getRepository().getBuild();
        GridNode node = build.getMasterStep().getNode();
        if (node == null) {
            throw new QuickbuildException("Can not locate node '" + build.getMasterStep().getNodeAddress() + "' to read source from. " + "The host name might has been changed recently.");
        }
        return (List)((Object)node.executeJob(SourceViewJob.class, new Serializable[]{this.sourceViewSupport, "readSourceByRevision", repositoryPath, revision}));
    }

    @Override
    public List<String> readSourceByEdition(String repositoryPath, String edition) {
        Build build = this.sourceViewSupport.getRepository().getBuild();
        GridNode node = build.getMasterStep().getNode();
        if (node == null) {
            throw new QuickbuildException("Can not locate node '" + build.getMasterStep().getNodeAddress() + "' to read source from. " + "The host name might has been changed recently.");
        }
        return (List)((Object)node.executeJob(SourceViewJob.class, new Serializable[]{this.sourceViewSupport, "readSourceByEdition", repositoryPath, edition}));
    }

    public static class SourceViewJob<T extends Revision>
    implements NodeJob {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Serializable execute(Serializable ... params) {
            SourceViewSupport delegate = (SourceViewSupport)params[0];
            Context.push(delegate.getRepository().getBuild());
            try {
                String methodName = (String)((Object)params[1]);
                if (methodName.equals("getRepositoryPath")) {
                    String string = delegate.getRepositoryPath((String)((Object)params[2]));
                    return string;
                }
                if (methodName.equals("readSourceByRevision")) {
                    Serializable serializable = (Serializable)((Object)delegate.readSourceByRevision((String)((Object)params[2]), (Revision)params[3]));
                    return serializable;
                }
                Serializable serializable = (Serializable)((Object)delegate.readSourceByEdition((String)((Object)params[2]), (String)((Object)params[3])));
                return serializable;
            }
            finally {
                Context.pop();
            }
        }
    }
}

