/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.repositorysupport;

import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.Revision;
import java.io.Serializable;
import java.util.List;

@ScriptApi(value="This class can be used to read file content from SCM repository.")
public abstract class SourceViewSupport<T extends Revision>
implements Serializable {
    private Repository<T> repository;

    public SourceViewSupport(Repository<T> repository) {
        this.repository = repository;
    }

    public Repository<T> getRepository() {
        return this.repository;
    }

    public abstract String getRepositoryPath(String var1);

    public abstract List<String> readSourceByRevision(String var1, T var2);

    public abstract List<String> readSourceByEdition(String var1, String var2);

    public List<String> readSource(String repositoryPath) {
        this.repository.takeSnapshot();
        return this.readSourceByRevision(repositoryPath, this.repository.getRevision());
    }

    public String readSourceAsString(String repositoryPath, String lineSeparator) {
        StringBuffer buffer = new StringBuffer();
        for (String line : this.readSource(repositoryPath)) {
            buffer.append(line).append(lineSeparator);
        }
        return buffer.toString();
    }

    @ScriptApi(value="Read content of a repository file with specified <a href=\"$docroot/Repository+Path\">repository path</a>. Revision of the file will be the same as the build.")
    public String readSourceAsString(String repositoryPath) {
        return this.readSourceAsString(repositoryPath, "\n");
    }
}

