/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.repositorysupport;

import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.migration.MigrationListener;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.repositorysupport.Revision;
import com.pmease.quickbuild.repositorysupport.RevisionInfo;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScriptApi(value="This class stores runtime information of a repository.")
public class RepositoryRuntime
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(RepositoryRuntime.class);
    private VersionedDocument revisionDOM;
    private RevisionInfo revisionInfo;
    private Object customData;
    private boolean checkout;

    @ScriptApi(value="Get revision of the repository used in the build. Null if unknown.")
    public Revision getRevision() {
        VersionedDocument dom = this.revisionDOM;
        if (dom != null) {
            try {
                return (Revision)dom.toBean(new MigrationListener(){

                    @Override
                    public void afterMigration(Object bean) {
                    }
                });
            }
            catch (Exception e) {
                logger.error("Error constructing revision from DOM.", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public void setRevision(Revision revision) {
        this.revisionDOM = revision != null ? VersionedDocument.fromBean(revision) : null;
    }

    @ScriptApi(value="Whether or not this repository is used to checkout code in the build.")
    public boolean isCheckout() {
        return this.checkout;
    }

    public void setCheckout(boolean checkout) {
        this.checkout = checkout;
    }

    public Object getCustomData() {
        return this.customData;
    }

    public void setCustomData(Object customData) {
        this.customData = customData;
    }

    public RevisionInfo getRevisionInfo() {
        return this.revisionInfo;
    }

    public void setRevisionInfo(RevisionInfo revisionInfo) {
        this.revisionInfo = revisionInfo;
    }

    public RepositoryRuntime clone() {
        RepositoryRuntime clone = new RepositoryRuntime();
        clone.checkout = this.checkout;
        clone.revisionDOM = this.revisionDOM;
        clone.revisionInfo = this.revisionInfo;
        return clone;
    }
}

