/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.repositorysupport;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ImplementationProvider;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Name;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.dependency.QuickbuildRepository;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.extensionpoint.RepositoryProvider;
import com.pmease.quickbuild.extensionpoint.support.TypeInstance;
import com.pmease.quickbuild.migration.MigrationListener;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.FailSafeRepository;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.repositorysupport.RepositoryRuntime;
import com.pmease.quickbuild.repositorysupport.Revision;
import com.pmease.quickbuild.repositorysupport.RevisionInfo;
import com.pmease.quickbuild.repositorysupport.ShortBranch;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.setting.repository.usermapping.SameNameMapping;
import com.pmease.quickbuild.setting.repository.usermapping.UserMapping;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.wicket.request.cycle.RequestCycle;
import org.dom4j.Element;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScriptApi
@ImplementationProvider(method="getImplementations")
public abstract class Repository<T extends Revision>
extends TypeInstance {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Repository.class);
    public static final String LOCAL_CHANGE_DIR = "local_change";
    public static final String REVERT_CHANGE_DIR = "revert_change";
    private String name;
    private String description;
    private int quietPeriod;
    private UserMapping userMapping = new SameNameMapping();
    @XStreamOmitField
    private List<Changeset> changes;
    @XStreamOmitField
    private boolean changesRecorded;
    @XStreamOmitField
    private boolean dirty;
    @XStreamOmitField
    private Build build;

    @Editable(order=20)
    @NotEmpty
    @Name
    @ScriptApi(value="Get name of the repository.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Editable(order=25)
    public String getType() {
        return EditorHelper.getName(this.getClass());
    }

    @Editable(order=30)
    @Multiline
    @ScriptApi(value="Get description of the repository.")
    @Scriptable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Editable(order=40, description="Number of seconds current repository should be quiet (without checkins) before QuickBuild decides to check out the code from this repository for a build. This is used to avoid checking out code in the middle of some other checkins. Set it as <b>0</b> if you do not want to use quiet period.")
    @ScriptApi(value="Get quiet period of the repository. 0 will be returned if quiet period is disabled.")
    @Advanced
    public int getQuietPeriod() {
        return this.quietPeriod;
    }

    public void setQuietPeriod(int quietPeriod) {
        this.quietPeriod = quietPeriod;
    }

    @Editable(order=50, description="Specify how to map committer name in this repository to QuickBuild user in order to associate SCM changesets with QuickBuild users.")
    @NotNull
    @ScriptApi(value="Get user mapping script.")
    @Advanced
    public UserMapping getUserMapping() {
        return this.userMapping;
    }

    public void setUserMapping(UserMapping userMapping) {
        this.userMapping = userMapping;
    }

    @ScriptApi(value="Get internal revision of the repository. Depending on the repository type, this maybe a changelist number, a transaction number of a timestamp. The revision stands for a snapshot of the repository.")
    public T getRevision() {
        return (T)this.getRuntime().getRevision();
    }

    @ScriptApi(value="Set revision of this repository.")
    public final void setRevision(T revision) {
        this.getRuntime().setRevision((Revision)revision);
        if (revision != null) {
            this.getRuntime().setRevisionInfo(this.getRevisionInfo(revision));
        } else {
            this.getRuntime().setRevisionInfo(null);
        }
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    protected RevisionInfo getRevisionInfo(T revision) {
        return null;
    }

    public void label(String label, String comment) {
        this.takeSnapshot();
        Context.getLogger().info("Creating label '" + label + "' on repository '" + this.getName() + "'...");
        this.labelOnRevision(this.getRevision(), label, comment);
    }

    public void checkout() {
        this.setCheckout(true);
        this.takeSnapshot();
        Context.getLogger().info("Checking out revision '" + this.getRuntime().getRevision() + "' of repository '" + this.getName() + "'...");
        if (this.isLocalChangeApplied()) {
            this.revertLocalChange();
        }
        this.checkoutByRevision(this.getRevision());
        if (Context.getConfiguration().isRecordSCMChanges()) {
            this.getChanges();
        }
    }

    public void commit(String comment) {
        throw new UnsupportedOperationException();
    }

    public void switchToHead() {
        throw new UnsupportedOperationException();
    }

    protected boolean isLocalChangeApplied() {
        File revertChangeDir = new File(Context.getConfiguration().getWorkspaceDir(), "revert_change/" + this.getName());
        return revertChangeDir.exists();
    }

    protected void revertLocalChange() {
        File revertChangeDir = new File(Context.getConfiguration().getWorkspaceDir(), "revert_change/" + this.getName());
        try {
            ProofBuildSupport<LocalChange> proofBuildSupport = this.getProofBuildSupport();
            if (proofBuildSupport != null) {
                Context.getLogger().info("Reverting local change for repository '{}'...", (Object)this.getName());
                File infoFile = new File(revertChangeDir, "info");
                LocalChange change = (LocalChange)BeanUtils.readFile(infoFile, null, LocalChange.class);
                File storeDir = new File(revertChangeDir, "store");
                FileUtils.sortPaths(change.getDeletePaths());
                Collections.reverse(change.getDeletePaths());
                for (String deletePath : change.getDeletePaths()) {
                    File deleteTarget = proofBuildSupport.getCheckoutFile(deletePath);
                    if (deleteTarget == null || !deleteTarget.exists()) continue;
                    if (deleteTarget.isFile()) {
                        FileUtils.deleteFile(deleteTarget);
                        continue;
                    }
                    FileUtils.deleteDir(deleteTarget);
                }
                FileUtils.sortPaths(change.getAddPaths());
                for (String addPath : change.getAddPaths()) {
                    File addTarget = proofBuildSupport.getCheckoutFile(addPath);
                    if (addTarget == null || addTarget.exists()) continue;
                    File fileToAdd = change.getStoredFile(storeDir, addPath);
                    if (fileToAdd.isDirectory()) {
                        FileUtils.createDir(addTarget);
                        continue;
                    }
                    FileUtils.copyFile(fileToAdd, addTarget, false, true);
                }
                for (String modifyPath : change.getModifyPaths()) {
                    File modifyTarget = proofBuildSupport.getCheckoutFile(modifyPath);
                    if (modifyTarget == null || !modifyTarget.exists() || !modifyTarget.isFile()) continue;
                    FileUtils.deleteFile(modifyTarget);
                    FileUtils.copyFile(change.getStoredFile(storeDir, modifyPath), modifyTarget, false, true);
                }
            } else {
                throw new QuickbuildException("Unable to revert local change since proof build support is disabled.");
            }
            FileUtils.deleteDir(revertChangeDir);
        }
        catch (Exception e) {
            Context.getLogger().warn("Error while reverting local change.", (Throwable)e);
            Context.getLogger().warn("Cleaning the workspace to make sure the checkout operation is not affected by above error.");
            FileUtils.cleanDir(Context.getConfiguration().getWorkspaceDir());
        }
    }

    @ScriptApi(value="Whether or not this repository have been used for checkout.")
    public boolean isCheckout() {
        return this.getRuntime().isCheckout();
    }

    public void setCheckout(boolean checkout) {
        this.getRuntime().setCheckout(checkout);
        this.dirty = true;
    }

    public T takeSnapshot() {
        T revision = this.getRevision();
        if (revision == null) {
            Context.getLogger().info("Taking snapshot of repository '" + this.getName() + "'...");
            if (this.getQuietPeriod() != 0) {
                Date quietDate = new Date(System.currentTimeMillis() - (long)this.getQuietPeriod() * 1000L);
                while (!this.isQuietSince(quietDate)) {
                    Context.getLogger().info("Repository '" + this.getName() + "' not quiet, waiting...");
                    try {
                        Thread.sleep((long)this.getQuietPeriod() * 1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    quietDate = new Date(System.currentTimeMillis() - (long)this.getQuietPeriod() * 1000L);
                }
            }
            Context.getLogger().info("Determining head revision for repository: " + this.getName());
            revision = this.getHeadRevision();
            this.setRevision(revision);
        }
        return revision;
    }

    @ScriptApi(value="Whether or not the repository is changed since last build.")
    public boolean isChanged() {
        return this.getBaseRevision() == null || !this.getChanges().isEmpty();
    }

    @ScriptApi(value="Whether or not specified path patterns are changed in the repository. Path patterns will be used to match paths displayed in the change set. Path patterns specified here should not be null.<br>Refer to <a href=\"$docroot/File+Pattern+Reference\">the file patterns reference</a> for details of the path patterns.")
    public boolean isChanged(String pathPatterns) {
        if (this.getBuild().getChangeBase() == null) {
            return true;
        }
        List<Pair<String, Boolean>> parsed = FileUtils.parsePathPatterns(pathPatterns);
        for (Changeset change : this.getChanges()) {
            for (Modification modification : change.getModifications()) {
                if (!FileUtils.matches(modification.getPath(), parsed)) continue;
                return true;
            }
        }
        return false;
    }

    @ScriptApi(value="Get current changes in the repository. Changes are sorted with latest change being the first element.")
    public List<Changeset> getChanges() {
        return this.getChanges(true);
    }

    @ScriptApi(value="Get current changes in the repository without external changes. Changes are sorted with latest change being the first element.")
    public List<Changeset> getChangesWithoutExternals() {
        ArrayList<Changeset> changes = new ArrayList<Changeset>();
        for (Changeset each : this.getChanges()) {
            if (each.getId().contains(":")) continue;
            changes.add(each);
        }
        return changes;
    }

    public List<Changeset> getChanges(boolean retrieve) {
        if (this.changes != null) {
            return this.changes;
        }
        if (Context.isBackend() && ObjectUtils.equals((Object)this.getBuild().getId(), (Object)Context.get().getId())) {
            if (retrieve) {
                Build baseBuild = this.build.getChangeBase();
                if (baseBuild == null) {
                    Context.getLogger().warn("Base build not exist to calculate change sets.");
                    this.changes = new ArrayList<Changeset>();
                    this.dirty = true;
                } else {
                    this.changes = this.getChangesSince(baseBuild);
                    this.dirty = true;
                }
            }
            return this.changes;
        }
        this.changes = Quickbuild.getServerService().readChanges(this.getBuild().getId(), this.getName());
        return this.changes;
    }

    public void setChanges(List<Changeset> changes) {
        this.changes = changes;
    }

    public boolean isChangesRecorded() {
        return this.changesRecorded;
    }

    public void setChangesRecorded(boolean changesRecorded) {
        this.changesRecorded = changesRecorded;
    }

    public T getRevision(Build build) {
        Repository<?> repository = build.getRepository(this.getName());
        if (repository == null) {
            Context.getLogger().warn("Can not find repository '" + this.getName() + "' in build '" + build.getVersion() + "', revision returned as null.");
            return null;
        }
        if (ClassUtils.unproxy(this.getClass()) != ClassUtils.unproxy(repository.getClass())) {
            Context.getLogger().warn("Repository '" + this.getName() + "' has been reconfigured since build '" + build.getVersion() + "', revision returned as null.");
            return null;
        }
        Object revision = repository.getRevision();
        if (revision == null) {
            Context.getLogger().warn("Repository '" + this.getName() + "' in build '" + build.getVersion() + "' does not have revision set.");
        }
        return (T)revision;
    }

    private Object getCustomData(Build build) {
        Repository<?> repository = build.getRepository(this.getName());
        if (repository == null) {
            Context.getLogger().warn("Can not find repository '" + this.getName() + "' in build '" + build.getVersion() + "', external info returned as null.");
            return null;
        }
        if (ClassUtils.unproxy(this.getClass()) != ClassUtils.unproxy(repository.getClass())) {
            Context.getLogger().warn("Repository '" + this.getName() + "' has been reconfigured since build '" + build.getVersion() + "', external info returned as null.");
            return null;
        }
        return repository.getRuntime().getCustomData();
    }

    public T getBaseRevision() {
        Build baseBuild = this.getBuild().getChangeBase();
        if (baseBuild != null) {
            return this.getRevision(baseBuild);
        }
        return null;
    }

    @ScriptApi(value="Get current changes in the repository since specified build without external changes. Changes are sorted with latest change being the first element.")
    public List<Changeset> getChangesSinceWithoutExternals(Build build) {
        ArrayList<Changeset> changes = new ArrayList<Changeset>();
        for (Changeset each : this.getChangesSince(build)) {
            if (each.getId().contains(":")) continue;
            changes.add(each);
        }
        return changes;
    }

    @ScriptApi(value="Get changes since specified build. Changes are sorted with the first entry being the most recent change.")
    public List<Changeset> getChangesSince(Build build) {
        T buildRevision = this.getRevision(build);
        if (buildRevision == null) {
            Context.getLogger().warn("Can not calculate change sets as revision of repository '" + this.getName() + "' is not set for base build '" + build.getVersion() + "'.");
            return new ArrayList<Changeset>();
        }
        Context.getLogger().info("Getting changes of '{}' since build '{}'...", (Object)this.getName(), (Object)build.getVersion());
        this.takeSnapshot();
        List<Changeset> changes = this.getChangesBetween(buildRevision, this.getRevision());
        Object customData = this.getRuntime().getCustomData();
        Object sinceCustomData = this.getCustomData(build);
        if (customData != null && sinceCustomData != null) {
            this.amendChanges(changes, customData, sinceCustomData);
        }
        Collections.sort(changes);
        int totalChangesets = 0;
        int totalModifications = 0;
        for (Changeset each : changes) {
            if ((totalModifications += each.getModifications().size()) > 20000) break;
            ++totalChangesets;
        }
        if (totalChangesets > 2000) {
            totalChangesets = 2000;
        }
        if (totalChangesets < changes.size()) {
            Context.getLogger().warn("There are too many changes found in repository '{}', truncating to save resource...", (Object)this.getName());
            if (totalChangesets != 0) {
                return new ArrayList<Changeset>(changes.subList(0, totalChangesets));
            }
            if (!changes.isEmpty()) {
                Changeset firstChange = changes.get(0);
                Changeset truncatedChange = new Changeset();
                truncatedChange.setClosedTasks(firstChange.getClosedTasks());
                truncatedChange.setComment(firstChange.getComment());
                truncatedChange.setDate(firstChange.getDate());
                truncatedChange.setId(firstChange.getId());
                truncatedChange.setUser(firstChange.getUser());
                if (firstChange.getModifications().size() <= 20000) {
                    truncatedChange.setModifications(firstChange.getModifications());
                } else {
                    truncatedChange.setModifications(firstChange.getModifications().subList(0, 20000));
                }
                changes = new ArrayList<Changeset>();
                changes.add(truncatedChange);
                return changes;
            }
            return changes;
        }
        return changes;
    }

    protected void amendChanges(List<Changeset> changes, Object customData, Object sinceCustomData) {
    }

    protected abstract void checkoutByRevision(T var1);

    protected abstract T getHeadRevision();

    protected abstract void labelOnRevision(T var1, String var2, String var3);

    public void promoteLabel(String label, String destination) {
        throw new UnsupportedOperationException();
    }

    protected abstract List<Changeset> getChangesBetween(T var1, T var2);

    protected abstract boolean isQuietSince(Date var1);

    @ScriptApi(value="Get proof build support object. Null if this repository does not support proof build or do not want to enable proof build.")
    public abstract ProofBuildSupport<? extends LocalChange> getProofBuildSupport();

    @ScriptApi(value="Get source view support of this repository. Null if this repository does not support to view source files.")
    public abstract SourceViewSupport<T> getSourceViewSupport();

    public String getEmail(String committer) {
        return null;
    }

    @ScriptApi(value="Get list of committers of this repository, with latest committer comes at top of the list.")
    public List<String> getCommitters(String repositoryPath, boolean exactMatch) {
        Validate.notNull((Object)Context.getConfiguration());
        ArrayList<Changeset> matched = new ArrayList<Changeset>();
        if (this.getChanges(false) != null) {
            block0: for (Changeset changeset : this.getChanges(false)) {
                for (Modification modification : changeset.getModifications()) {
                    if ((!exactMatch || !modification.getPath().equals(repositoryPath)) && (exactMatch || !modification.getPath().contains(repositoryPath))) continue;
                    matched.add(changeset);
                    continue block0;
                }
            }
        }
        return this.getCommitters(matched);
    }

    @ScriptApi(value="Get list of committers of this repository, with latest committer comes at the top of the list.")
    public List<String> getCommitters() {
        Validate.notNull((Object)Context.getConfiguration());
        if (this.getChanges(false) != null) {
            return this.getCommitters(new ArrayList<Changeset>(this.getChanges(false)));
        }
        return this.getCommitters(new ArrayList<Changeset>());
    }

    @ScriptApi(value="Get list of committers of this repository since previous successful build, with latest committer comes at the top of the list.")
    public List<String> getCommittersSincePrevSuccess() {
        Validate.notNull((Object)Context.getBuild());
        Build previous = BuildManager.instance.getPrevious(Context.getBuild());
        if (previous != null) {
            if (previous.isSuccessful()) {
                return this.getCommitters(this.getChanges());
            }
            Build previousSuccessful = BuildManager.instance.getPreviousSuccessful(Context.getBuild());
            if (previousSuccessful != null) {
                if (System.getProperty("CALC_PREV_SUCCESS_CHANGE_FROM_DB") != null) {
                    ArrayList<Changeset> changesSincePrevSuccess = new ArrayList<Changeset>();
                    for (Build build : BuildManager.instance.getBuildsBetween(previousSuccessful, Context.getBuild())) {
                        changesSincePrevSuccess.addAll(Quickbuild.getServerService().readChanges(build.getId(), this.getName()));
                    }
                    changesSincePrevSuccess.addAll(this.getChanges());
                    for (Changeset changeset : changesSincePrevSuccess) {
                        System.err.println(changeset.getComment());
                    }
                    return this.getCommitters(changesSincePrevSuccess);
                }
                return this.getCommitters(this.getChangesSince(previousSuccessful));
            }
            return new ArrayList<String>();
        }
        return new ArrayList<String>();
    }

    private List<String> getCommitters(List<Changeset> changesets) {
        if (this instanceof QuickbuildRepository) {
            return new ArrayList<String>();
        }
        Collections.sort(changesets, new Comparator<Changeset>(){

            @Override
            public int compare(Changeset changeset1, Changeset changeset2) {
                if (changeset1.getDate() == null) {
                    return 1;
                }
                if (changeset2.getDate() == null) {
                    return -1;
                }
                return changeset2.getDate().compareTo(changeset1.getDate());
            }
        });
        ArrayList<String> committers = new ArrayList<String>();
        for (Changeset changeset : changesets) {
            if (changeset.getUser() == null || committers.contains(changeset.getUser())) continue;
            committers.add(changeset.getUser());
        }
        return committers;
    }

    @ScriptApi(value="Map committer to QuickBuild user name. Null will be returned if the committer can not be mapped to a QuickBuild user.")
    public String getUserName(String committer) {
        return this.getUserMapping().map(this, committer);
    }

    public static Repository<?> fromDOM(final Configuration configuration, VersionedDocument dom) {
        try {
            return (Repository)dom.toBean(new MigrationListener(){

                @Override
                public void afterMigration(Object bean) {
                    Repository repository = (Repository)bean;
                    ConfigurationManager.instance.saveRepository(configuration.getId(), repository);
                }
            });
        }
        catch (Exception e) {
            if (RequestCycle.get() != null) {
                logger.error("Error constructing repository from DOM.", (Throwable)e);
                FailSafeRepository repository = new FailSafeRepository();
                repository.setName(dom.getValue("name"));
                repository.setDescription(e.getClass().getSimpleName() + ":" + e.getMessage());
                return repository;
            }
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }

    public RepositoryRuntime getRuntime() {
        RepositoryRuntime runtime = this.getBuild().getRepositoryRuntimes().get(this.getName());
        if (runtime == null) {
            runtime = new RepositoryRuntime();
            this.getBuild().getRepositoryRuntimes().put(this.getName(), runtime);
        }
        return runtime;
    }

    public void buildFinished() {
    }

    public Collection<ShortBranch> getShortBranches() {
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Repository)) {
            return false;
        }
        Repository otherRepository = (Repository)other;
        return new EqualsBuilder().append((Object)this.getName(), (Object)otherRepository.getName()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getName()).toHashCode();
    }

    public String toString() {
        return this.getName();
    }

    private static Collection<Class<?>> getImplementations() {
        HashSet implementations = new HashSet();
        for (RepositoryProvider provider : PluginManager.instance.getExtensions(RepositoryProvider.class)) {
            Class<? extends Repository<?>> repositoryClass = provider.getRepositoryClass();
            if (repositoryClass == null) continue;
            implementations.add(repositoryClass);
        }
        return implementations;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().element("checkout").detach();
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        Element userMappingScriptElement = dom.getRootElement().element("userMappingScript");
        userMappingScriptElement.setName("userMapping");
        String userMappingScript = userMappingScriptElement.getText().trim();
        userMappingScriptElement.clearContent();
        if (userMappingScript.equals("return committer;")) {
            userMappingScriptElement.addAttribute("class", "com.pmease.quickbuild.setting.repository.SameNameMapping");
        } else {
            userMappingScriptElement.addAttribute("class", "com.pmease.quickbuild.setting.repository.ScriptMapping").addElement("script").setText(userMappingScript);
        }
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        Element userMappingElement = dom.getRootElement().element("userMapping");
        String className = userMappingElement.attributeValue("class").replace("repository", "repository.usermapping");
        userMappingElement.addAttribute("class", className);
        Element entriesElement = userMappingElement.element("entries");
        if (entriesElement != null) {
            for (Element entryElement : entriesElement.elements()) {
                entryElement.setName(entryElement.getName().replace("repository", "repository.usermapping"));
            }
        }
    }

    @ScriptApi(value="Get build object associated with the repository. Null if no build object is associated with this repository.")
    public Build getBuild() {
        if (this.build == null) {
            throw new QuickbuildException("The repository is not associated with any build.");
        }
        return this.build;
    }

    public void setBuild(Build build) {
        this.build = build;
    }

    public Object writeReplace() throws ObjectStreamException {
        if (this.build != null) {
            return new SerializedForm(this);
        }
        return this;
    }

    public static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Build build;
        private String repositoryName;

        public SerializedForm(Repository<?> repository) {
            this.build = repository.getBuild();
            this.repositoryName = repository.getName();
        }

        public Object readResolve() throws ObjectStreamException {
            return this.build.getRepository(this.repositoryName);
        }
    }
}

