/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.repositorysupport;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.stepsupport.RepositoryStep;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Record Changes", order=1000, category={"Repository"}, description="This step can be used to record changes of specified repository even if it is not used for checkout.")
@ScriptApi(value="Record changes of specified repository.")
public class RecordChangesStep
extends RepositoryStep {
    private static final long serialVersionUID = 1L;

    @Override
    @Editable(name="Repository", order=500)
    @ChoiceProvider(value="getAvailableRepositoryNames")
    @NotEmpty
    @ScriptApi(value="Get name of the repository to record chanages.")
    public String getRepositoryName() {
        return super.getRepositoryName();
    }

    @Override
    public void run() {
        Build build = Context.getBuild();
        Repository<?> repository = this.getRepository();
        if (!repository.isChangesRecorded() && build.getConfiguration().isRecordSCMChanges()) {
            Quickbuild.getServerService().writeChanges(build.getId(), repository.getName(), repository.getChanges());
            repository.setChangesRecorded(true);
            repository.setDirty(true);
        }
    }
}

