/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.repositorysupport;

import com.pmease.quickbuild.BuildAwareJob;
import com.pmease.quickbuild.BuildAwareTask;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridJob;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.repositorysupport.ProofBuildFinishJob;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ProofBuildFinishTask
extends BuildAwareTask<String, Void> {
    public ProofBuildFinishTask(Build build) {
        super(build);
    }

    @Override
    protected Void reduce(Collection<GridJob> results) {
        for (GridJob job : results) {
            if (job.getException() == null) continue;
            throw new RuntimeException("Error executing proof build finish job.", job.getException());
        }
        return null;
    }

    @Override
    protected Map<BuildAwareJob, GridNode> map(String repositoryName) {
        if (this.getBuild().getRequester() == null) {
            throw new QuickbuildException("Can not run proof build against repository '" + repositoryName + "' since build is requested by anonymous or scheduler.");
        }
        Grid buildGrid = Quickbuild.getInstance(Grid.class);
        GridNode userAgent = buildGrid.getUserNode(this.getBuild().getRequester());
        if (userAgent == null) {
            throw new QuickbuildException("Can not map local change finishing job as agent of user '" + this.getBuild().getRequester().getName() + "' is not found");
        }
        HashMap<BuildAwareJob, GridNode> map = new HashMap<BuildAwareJob, GridNode>();
        map.put(new ProofBuildFinishJob(this.getId(), this.getBuild(), repositoryName), userAgent);
        return map;
    }
}

