/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.repositorysupport;

import com.pmease.quickbuild.annotation.ScriptApi;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@ScriptApi
public class Modification
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String UNCLEAR_PREFIX = "...";
    private Action action;
    private String path;
    private String edition;
    private String previousEdition;
    private PathType pathType;

    @ScriptApi(value="Get action of this modification. Action is a not null Java Enum with three possible values: <em>ADD</em>, <em>DELETE</em> and <em>MODIFY</em>. ")
    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    @ScriptApi(value="Get path of the modified file/directory in repository. Will not be null.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @ScriptApi(value="Get edition of the modified file/directory. Null if unknown.")
    public String getEdition() {
        return this.edition;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }

    @ScriptApi(value="Get edition of the file/directory before modification. Null if unknown.")
    public String getPreviousEdition() {
        return this.previousEdition;
    }

    public void setPreviousEdition(String previousEdition) {
        this.previousEdition = previousEdition;
    }

    @ScriptApi(value="Get type of the path. Null if unknown.")
    public PathType getPathType() {
        return this.pathType;
    }

    public void setPathType(PathType pathType) {
        this.pathType = pathType;
    }

    public String toString() {
        return "path:" + this.getPath() + ", action:" + this.getAction().name() + ", edition:" + this.getEdition();
    }

    public static void merge(List<Modification> mods1, List<Modification> mods2) {
        for (Modification mod2 : mods2) {
            Modification mod1 = null;
            for (Modification each : mods1) {
                if (!each.getPath().equals(mod2.getPath())) continue;
                mod1 = each;
                break;
            }
            if (mod1 != null) {
                if (mod1.getAction() == Action.ADD) {
                    if (mod2.getAction() == Action.DELETE) {
                        mods1.remove(mod1);
                        continue;
                    }
                    mod1.setEdition(mod2.getEdition());
                    continue;
                }
                if (mod1.getAction() == Action.DELETE) {
                    if (mod2.getAction() != Action.MODIFY && mod2.getAction() != Action.ADD) continue;
                    mod1.setAction(Action.MODIFY);
                    mod1.setEdition(mod2.getEdition());
                    continue;
                }
                if (mod2.getAction() == Action.MODIFY || mod2.getAction() == Action.ADD) {
                    mod1.setEdition(mod2.getEdition());
                    continue;
                }
                mod1.setAction(Action.DELETE);
                continue;
            }
            mods1.add(mod2);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof Modification)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Modification otherModification = (Modification)other;
        return new EqualsBuilder().append((Object)this.getPath(), (Object)otherModification.getPath()).append((Object)this.getEdition(), (Object)otherModification.getEdition()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getPath()).append((Object)this.getEdition()).toHashCode();
    }

    public static enum PathType {
        TEXT,
        BINARY,
        DIR;

    }

    public static enum Action {
        ADD,
        DELETE,
        MODIFY;

    }
}

