/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.repositorysupport;

import com.pmease.quickbuild.BuildAwareJob;
import com.pmease.quickbuild.BuildAwareTask;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridJob;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.repositorysupport.LocalChangeCollectJob;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.util.Pair;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class LocalChangeCollectTask
extends BuildAwareTask<Pair<StepPath, String>, File> {
    public LocalChangeCollectTask(Build build) {
        super(build);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected File reduce(Collection<GridJob> results) {
        Build build;
        LocalChangeCollectJob job = (LocalChangeCollectJob)results.iterator().next();
        if (job.getException() != null) {
            throw new RuntimeException("Error executing local change collect job.", job.getException());
        }
        Build build2 = build = this.getBuild();
        synchronized (build2) {
            build.setReports(job.getBuild().getReports());
            build.getRepositoryCache().putAll(job.getBuild().getRepositoryCache());
            build.getRepositoryRuntimes().putAll(job.getBuild().getRepositoryRuntimes());
            build.getVariables().putAll(job.getBuild().getVariables());
        }
        return new File(build.getConfiguration().getWorkspaceDir(), "local_change/" + job.getReposioryName());
    }

    @Override
    protected Map<BuildAwareJob, GridNode> map(Pair<StepPath, String> param) {
        StepPath stepPath = param.getFirst();
        String repositoryName = param.getSecond();
        if (this.getBuild().isScheduled()) {
            throw new QuickbuildException("Proof build is not applicable for scheduled build (repository: " + repositoryName + ").");
        }
        User user = this.getBuild().getRequester();
        if (user == null) {
            throw new QuickbuildException("Proof build is not applicable when build is triggered by anonymous user (repository: " + repositoryName + ").");
        }
        Grid buildGrid = Quickbuild.getInstance(Grid.class);
        GridNode userAgent = buildGrid.getUserNode(user);
        if (userAgent == null) {
            throw new QuickbuildException("Local change can not be collected as agent of user '" + user.getName() + "' is not found.");
        }
        HashMap<BuildAwareJob, GridNode> map = new HashMap<BuildAwareJob, GridNode>();
        map.put(new LocalChangeCollectJob(this.getId(), this.getBuild(), stepPath, repositoryName), userAgent);
        return map;
    }
}

