/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.repositorysupport;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.stepsupport.StepAwareJob;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import org.apache.commons.lang.Validate;

public class LocalChangeCollectJob
extends StepAwareJob {
    private static final long serialVersionUID = 1L;
    private String repositoryName;

    public LocalChangeCollectJob(String taskId, Build build, StepPath stepPath, String repositoryName) {
        super(taskId, build, stepPath);
        this.repositoryName = repositoryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeStepAwareJob() {
        Class<ProofBuildSupport> clazz = ProofBuildSupport.class;
        synchronized (ProofBuildSupport.class) {
            File changeDir = new File(Bootstrap.getTempDir(), "local_change");
            if (changeDir.exists()) {
                FileUtils.cleanDir(changeDir);
            } else {
                FileUtils.createDir(changeDir);
            }
            File changeStoreDir = new File(changeDir, "store");
            Repository<?> repository = this.getBuild().getRepository(this.repositoryName);
            Validate.notNull(repository);
            ProofBuildSupport<LocalChange> proofBuildSupport = repository.getProofBuildSupport();
            Validate.notNull(proofBuildSupport);
            Context.getLogger().info("Getting local change...");
            LocalChange change = proofBuildSupport.getLocalChange(changeStoreDir);
            if (Context.getLogger().isDebugEnabled()) {
                Context.getLogger().debug("Local change:");
                for (String addPath : change.getAddPaths()) {
                    Context.getLogger().debug("***** ADD: " + addPath);
                }
                for (String deletePath : change.getDeletePaths()) {
                    Context.getLogger().debug("***** DELETE: " + deletePath);
                }
                for (String modifyPath : change.getModifyPaths()) {
                    Context.getLogger().debug("***** MODIFY: " + modifyPath);
                }
            }
            BeanUtils.writeFile(change, new File(changeDir, "info"));
            GridNode localNode = Grid.instance.getLocalNode();
            String changeDirPathAtTaskNode = this.getTaskNode().getWorkspaceDir(this.getBuild().getConfiguration().getId()) + "/" + "local_change" + "/" + this.repositoryName;
            this.getTaskNode().deleteDir(changeDirPathAtTaskNode);
            Grid.instance.transferFiles(localNode, changeDir.getAbsolutePath(), "**,defaultexcludes=no", this.getTaskNode(), changeDirPathAtTaskNode, false, null, null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getReposioryName() {
        return this.repositoryName;
    }
}

