/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.repositorysupport;

import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.Modification;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;

public class FlatChange
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String user;
    private Date date;
    private String changesetId;
    private String comment;
    private Modification.Action action;
    private String path;
    private String edition;
    private String previousEdition;
    private static final int FLATCHANGE_AGGREGATE_THRESHOLD = 60;

    public void reset() {
        this.user = null;
        this.changesetId = null;
        this.comment = null;
        this.path = null;
        this.edition = null;
        this.previousEdition = null;
        this.date = null;
        this.action = null;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getChangesetId() {
        return this.changesetId;
    }

    public void setChangesetId(String changesetId) {
        this.changesetId = changesetId;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void appendCommentLine(String line) {
        this.comment = this.comment == null || this.comment.length() == 0 ? line : this.comment + "\n" + line;
    }

    public Modification.Action getAction() {
        return this.action;
    }

    public void setAction(Modification.Action action) {
        this.action = action;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getEdition() {
        return this.edition;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }

    public String getPreviousEdition() {
        return this.previousEdition;
    }

    public void setPreviousEdition(String previousEdition) {
        this.previousEdition = previousEdition;
    }

    public static List<Changeset> aggregate(List<FlatChange> flatChanges) {
        LinkedList<Changeset> changesets = new LinkedList<Changeset>();
        for (FlatChange flatChange : flatChanges) {
            Changeset changeset = FlatChange.findChangeset(changesets, flatChange.getChangesetId(), flatChange.getUser(), flatChange.getDate(), flatChange.getComment());
            if (changeset == null) {
                changeset = new Changeset();
                changeset.setId(flatChange.getChangesetId());
                changeset.setUser(flatChange.getUser());
                changeset.setComment(flatChange.getComment());
                changeset.setDate(flatChange.getDate());
                changesets.add(changeset);
            }
            Modification modification = new Modification();
            modification.setPath(flatChange.getPath());
            modification.setAction(flatChange.getAction());
            modification.setEdition(flatChange.getEdition());
            modification.setPreviousEdition(flatChange.getPreviousEdition());
            changeset.getModifications().add(modification);
        }
        HashSet<String> usedIds = new HashSet<String>();
        for (Changeset changeset : changesets) {
            if (changeset.getId() == null) {
                String id = changeset.getDate() != null ? String.valueOf(changeset.getDate().getTime()) : String.valueOf(System.currentTimeMillis());
                changeset.setId(id);
                int i = 1;
                while (usedIds.contains(changeset.getId())) {
                    changeset.setId(id + String.valueOf(i++));
                }
            }
            usedIds.add(changeset.getId());
        }
        return changesets;
    }

    private static Changeset findChangeset(List<Changeset> changesets, String changesetId, String user, Date date, String comment) {
        if (changesetId != null) {
            for (Changeset changeset : changesets) {
                if (!changesetId.equals(changeset.getId()) || !ObjectUtils.equals((Object)comment, (Object)changeset.getComment())) continue;
                return changeset;
            }
            return null;
        }
        if (date == null) {
            return null;
        }
        if (user != null) {
            for (Changeset changeset : changesets) {
                if (!user.equals(changeset.getUser()) || changeset.getDate() == null || !ObjectUtils.equals((Object)comment, (Object)changeset.getComment()) || Math.abs(date.getTime() - changeset.getDate().getTime()) >= 60000L) continue;
                return changeset;
            }
            return null;
        }
        for (Changeset changeset : changesets) {
            if (changeset.getUser() != null || changeset.getDate() == null || !ObjectUtils.equals((Object)comment, (Object)changeset.getComment()) || Math.abs(date.getTime() - changeset.getDate().getTime()) >= 60000L) continue;
            return changeset;
        }
        return null;
    }

    public FlatChange clone() {
        FlatChange change = new FlatChange();
        change.setAction(this.getAction());
        change.setChangesetId(this.getChangesetId());
        change.setComment(this.getComment());
        change.setDate(this.getDate());
        change.setEdition(this.getEdition());
        change.setPath(this.getPath());
        change.setPreviousEdition(this.getPreviousEdition());
        change.setUser(this.getUser());
        return change;
    }
}

