/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.repositorysupport;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.dependency.DependencyInfo;
import com.pmease.quickbuild.dependency.QuickbuildRepository;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.GridTaskFuture;
import com.pmease.quickbuild.grid.ServerService;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.repositorysupport.LocalChange;
import com.pmease.quickbuild.repositorysupport.LocalChangeCollectTask;
import com.pmease.quickbuild.repositorysupport.ProofBuildSupport;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.stepsupport.RepositoryStep;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.page.build.StepBuildInfoPanel;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.util.io.IOUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Checkout", order=10, category={"Repository"}, description="This step can be used to check out files from specified repository.")
@ScriptApi(value="Checkout specified repository.")
public class CheckoutStep
extends RepositoryStep {
    private static final long serialVersionUID = 1L;

    @Override
    @Editable(name="Repository", order=500)
    @ChoiceProvider(value="getAvailableRepositoryNames")
    @NotEmpty
    @ScriptApi(value="Get name of the repository to checkout.")
    public String getRepositoryName() {
        return super.getRepositoryName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Build build = Context.getBuild();
        Repository<?> repository = this.getRepository();
        try {
            repository.checkout();
        }
        finally {
            if (!repository.isChangesRecorded() && build.getConfiguration().isRecordSCMChanges()) {
                Quickbuild.getServerService().writeChanges(build.getId(), repository.getName(), repository.getChanges());
                repository.setChangesRecorded(true);
            }
            if (repository instanceof QuickbuildRepository) {
                QuickbuildRepository qbRepo = (QuickbuildRepository)repository;
                if (qbRepo.getServer() == null) {
                    ArrayList<Long> buildIds = new ArrayList<Long>();
                    for (DependencyInfo info : qbRepo.getRevision().getValue()) {
                        buildIds.add(info.getBuildId());
                    }
                    this.getRuntime().setCustomData(buildIds);
                }
            } else {
                this.getRuntime().setCustomData("Checkout revision: " + repository.getRevision());
            }
        }
        ProofBuildSupport<LocalChange> proofBuildSupport = repository.getProofBuildSupport();
        if (proofBuildSupport != null && proofBuildSupport.getProofCondition().satisfied(repository)) {
            GridTaskFuture<File> taskFuture = Grid.instance.execute(new LocalChangeCollectTask(build), new Pair<StepPath, String>(this.getPath(), repository.getName()));
            File localChangeDir = taskFuture.get();
            File revertChangeDir = new File(Context.getConfiguration().getWorkspaceDir(), "revert_change/" + repository.getName());
            FileUtils.createDir(revertChangeDir);
            try {
                Context.getLogger().info("Applying local change for repository '{}'...", (Object)repository.getName());
                this.applyLocalChange(proofBuildSupport, localChangeDir, revertChangeDir);
                GridNode localNode = Grid.instance.getLocalNode();
                GridNode serverNode = Grid.instance.getServerNode();
                ServerService serverService = Quickbuild.getServerService();
                String buildPublishDirAtServer = serverService.getBuildPublishDir(build.getId());
                String localChangeDirAtServer = buildPublishDirAtServer + "/" + "local_change";
                Grid.instance.transferFiles(localNode, localChangeDir.getAbsolutePath(), "**", serverNode, localChangeDirAtServer + "/" + repository.getName(), false, null, localChangeDirAtServer);
            }
            finally {
                FileUtils.deleteDir(localChangeDir);
            }
        }
    }

    private void applyLocalChange(ProofBuildSupport<?> proofBuildSupport, File localChangeDir, File revertChangeDir) {
        LocalChange revertChange;
        File localChangeInfoFile = new File(localChangeDir, "info");
        LocalChange localChange = (LocalChange)BeanUtils.readFile(localChangeInfoFile, null);
        File localChangeStoreDir = new File(localChangeDir, "store");
        File revertChangeInfoFile = new File(revertChangeDir, "info");
        File revertChangeStoreDir = new File(revertChangeDir, "store");
        try {
            revertChange = (LocalChange)localChange.getClass().newInstance();
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
        FileUtils.sortPaths(localChange.getDeletePaths());
        Collections.reverse(localChange.getDeletePaths());
        Iterator<String> it = localChange.getDeletePaths().iterator();
        while (it.hasNext()) {
            String deletePath = it.next();
            File deleteTarget = proofBuildSupport.getCheckoutFile(deletePath);
            if (deleteTarget != null && deleteTarget.exists()) {
                if (deleteTarget.isFile()) {
                    FileUtils.copyFile(deleteTarget, localChange.getStoredFile(revertChangeStoreDir, deletePath), false, true);
                } else {
                    FileUtils.createDir(localChange.getStoredFile(revertChangeStoreDir, deletePath));
                    Stack<File> descendents = new Stack<File>();
                    descendents.addAll(Arrays.asList(deleteTarget.listFiles()));
                    while (!descendents.isEmpty()) {
                        File childFile = (File)descendents.pop();
                        String childDeletePath = deletePath + FileUtils.getRelativePath(childFile.getAbsolutePath(), deleteTarget.getAbsolutePath());
                        revertChange.getAddPaths().add(childDeletePath);
                        if (childFile.isFile()) {
                            FileUtils.copyFile(childFile, localChange.getStoredFile(revertChangeStoreDir, childDeletePath), false, true);
                            continue;
                        }
                        FileUtils.createDir(localChange.getStoredFile(revertChangeStoreDir, childDeletePath));
                        descendents.addAll(Arrays.asList(childFile.listFiles()));
                    }
                }
                revertChange.getAddPaths().add(deletePath);
                if (deleteTarget.isFile()) {
                    FileUtils.deleteFile(deleteTarget);
                    continue;
                }
                FileUtils.deleteDir(deleteTarget);
                continue;
            }
            it.remove();
        }
        FileUtils.sortPaths(localChange.getAddPaths());
        it = localChange.getAddPaths().iterator();
        while (it.hasNext()) {
            String addPath = it.next();
            File addTarget = proofBuildSupport.getCheckoutFile(addPath);
            if (addTarget != null && !addTarget.exists()) {
                revertChange.getDeletePaths().add(addPath);
                File fileToAdd = localChange.getStoredFile(localChangeStoreDir, addPath);
                File parent = addTarget.getParentFile();
                while (!parent.exists()) {
                    String lastDeletePath = revertChange.getDeletePaths().get(revertChange.getDeletePaths().size() - 1);
                    revertChange.getDeletePaths().add(StringUtils.substringBeforeLast((String)lastDeletePath, (String)"/"));
                    parent = parent.getParentFile();
                }
                FileUtils.createDir(addTarget.getParentFile());
                if (fileToAdd.isDirectory()) {
                    FileUtils.createDir(addTarget);
                    continue;
                }
                FileUtils.copyFile(fileToAdd, addTarget, false);
                continue;
            }
            it.remove();
        }
        it = localChange.getModifyPaths().iterator();
        while (it.hasNext()) {
            block24: {
                boolean contentEquals;
                String modifyPath = it.next();
                File modifyTarget = proofBuildSupport.getCheckoutFile(modifyPath);
                if (modifyTarget == null || !modifyTarget.exists() || !modifyTarget.isFile()) break block24;
                File revertFile = localChange.getStoredFile(revertChangeStoreDir, modifyPath);
                File storedFile = localChange.getStoredFile(localChangeStoreDir, modifyPath);
                File prevFile = new File(storedFile.getAbsolutePath() + ".qbprev");
                if (prevFile.exists()) {
                    FileUtils.copyFile(modifyTarget, prevFile);
                }
                FileInputStream modifyTargetStream = null;
                FileInputStream storedFileStream = null;
                try {
                    modifyTargetStream = new FileInputStream(modifyTarget);
                    storedFileStream = new FileInputStream(storedFile);
                    contentEquals = IOUtils.contentEquals((InputStream)modifyTargetStream, (InputStream)storedFileStream);
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(modifyTargetStream);
                        IOUtils.closeQuietly(storedFileStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)modifyTargetStream);
                IOUtils.closeQuietly((Closeable)storedFileStream);
                if (!contentEquals) {
                    FileUtils.copyFile(modifyTarget, revertFile, false, true);
                    revertChange.getModifyPaths().add(modifyPath);
                    FileUtils.deleteFile(modifyTarget);
                    FileUtils.copyFile(storedFile, modifyTarget, false);
                    continue;
                }
                it.remove();
                continue;
            }
            it.remove();
        }
        if (Context.getLogger().isDebugEnabled()) {
            Context.getLogger().debug("Derived revert change:");
            for (String addPath : revertChange.getAddPaths()) {
                Context.getLogger().debug("***** ADD: " + addPath);
            }
            for (String deletePath : revertChange.getDeletePaths()) {
                Context.getLogger().debug("***** DELETE: " + deletePath);
            }
            for (String modifyPath : revertChange.getModifyPaths()) {
                Context.getLogger().debug("***** MODIFY: " + modifyPath);
            }
        }
        BeanUtils.writeFile(revertChange, revertChangeInfoFile);
        BeanUtils.writeFile(localChange, localChangeInfoFile);
    }

    @Override
    public Component renderCustomRuntimeData(String panelId, final Object customRuntimeData) {
        if (customRuntimeData instanceof String) {
            return new Label(panelId, (String)customRuntimeData);
        }
        if (customRuntimeData instanceof List) {
            return new StepBuildInfoPanel(panelId, "Dependency builds: ", (IModel<List<Build>>)new LoadableDetachableModel<List<Build>>(){

                protected List<Build> load() {
                    ArrayList<Build> builds = new ArrayList<Build>();
                    for (Long buildId : (List)customRuntimeData) {
                        Build build = (Build)BuildManager.instance.get(buildId);
                        if (build == null) continue;
                        builds.add(build);
                    }
                    return builds;
                }
            });
        }
        if (customRuntimeData instanceof Long) {
            return new StepBuildInfoPanel(panelId, "Dependency builds: ", (IModel<List<Build>>)new LoadableDetachableModel<List<Build>>(){

                protected List<Build> load() {
                    ArrayList<Build> builds = new ArrayList<Build>();
                    Long buildId = (Long)customRuntimeData;
                    Build build = (Build)BuildManager.instance.get(buildId);
                    if (build != null) {
                        builds.add(build);
                    }
                    return builds;
                }
            });
        }
        return null;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
            versions.push(0);
        }
    }
}

