/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.repositorysupport;

import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.repositorysupport.Modification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@ScriptApi(value="Represents a changeset in a repository.")
public class Changeset
implements Serializable,
Comparable<Changeset> {
    private static final long serialVersionUID = 1L;
    private String user;
    private Date date;
    private String id;
    private String comment;
    private List<Modification> modifications = new ArrayList<Modification>();
    private Set<String> closedTasks;

    @ScriptApi(value="Get user who committed this change. Null if unknown.")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @ScriptApi(value="Get date of the change. Null if unknown.")
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @ScriptApi(value="Get identifier of the change. Will not be null.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ScriptApi(value="Get comment of the change. Null if no comment.")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @ScriptApi(value="Get list of modifications contained in this change set.")
    public List<Modification> getModifications() {
        return this.modifications;
    }

    public void setModifications(List<Modification> modifications) {
        this.modifications = modifications;
    }

    public Set<String> getClosedTasks() {
        if (this.closedTasks == null) {
            this.closedTasks = new HashSet<String>();
        }
        return this.closedTasks;
    }

    public void setClosedTasks(Set<String> closedTasks) {
        this.closedTasks = closedTasks;
    }

    @Override
    public int compareTo(Changeset other) {
        if (this.getDate() == null && other.getDate() == null) {
            return 0;
        }
        if (this.getDate() == null) {
            return 1;
        }
        if (other.getDate() == null) {
            return -1;
        }
        return other.getDate().compareTo(this.getDate());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("--------------------------------------------------------------------------------\n");
        sb.append("Revision:       ").append(this.getId()).append("\n");
        sb.append("User:           ").append(this.getUser()).append("\n");
        sb.append("Date:           ").append(this.getDate()).append("\n");
        sb.append("Comment:        \n");
        sb.append(this.getComment()).append("\n");
        sb.append("Modifications:  \n");
        for (Modification m : this.modifications) {
            sb.append("  ").append((Object)m.getAction()).append("\t").append(m.getPath()).append("\t").append(m.getEdition()).append(":").append(m.getPreviousEdition()).append("\t").append((Object)m.getPathType()).append("\n");
        }
        return sb.toString();
    }
}

