/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.repositorysupport;

import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.Modification;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

@ScriptApi(value="This class represents a changeset of the build.")
public class BuildChangeset
implements Serializable,
Comparable<BuildChangeset> {
    private static final long serialVersionUID = 1L;
    private String repositoryName;
    private Changeset changeset = new Changeset();

    public BuildChangeset(String repositoryName, String changeId) {
        this.setRepositoryName(repositoryName);
        this.changeset.setId(changeId);
    }

    public BuildChangeset(String repositoryName, Changeset changeset) {
        this.setRepositoryName(repositoryName);
        this.changeset = changeset;
    }

    @ScriptApi(value="Get enclosed changeset object.")
    public Changeset getChangeset() {
        return this.changeset;
    }

    @ScriptApi(value="Get name of the repository containing this changeset.")
    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    @ScriptApi(value="Get user who committed this change. Null if unknown.")
    public String getUser() {
        return this.changeset.getUser();
    }

    public void setUser(String user) {
        this.changeset.setUser(user);
    }

    @ScriptApi(value="Get date of the change. Null if unknown.")
    public Date getDate() {
        return this.changeset.getDate();
    }

    public void setDate(Date date) {
        this.changeset.setDate(date);
    }

    @ScriptApi(value="Get identifier of the change. Will not be null.")
    public String getId() {
        return this.changeset.getId();
    }

    public void setId(String id) {
        this.changeset.setId(id);
    }

    @ScriptApi(value="Get comment of the change. Null if no comment.")
    public String getComment() {
        return this.changeset.getComment();
    }

    public void setComment(String comment) {
        this.changeset.setComment(comment);
    }

    @ScriptApi(value="Get list of modifications contained in this change set.")
    public List<Modification> getModifications() {
        return this.changeset.getModifications();
    }

    public void setModifications(List<Modification> modifications) {
        this.changeset.setModifications(modifications);
    }

    @ScriptApi(value="Get closed tasks in this changeset. Null or empty set if there is no closed tasks.")
    public Set<String> getClosedTasks() {
        return this.changeset.getClosedTasks();
    }

    public void setClosedTasks(Set<String> closedTasks) {
        this.changeset.setClosedTasks(closedTasks);
    }

    @Override
    public int compareTo(BuildChangeset other) {
        if (this.getDate() == null) {
            return 1;
        }
        if (other.getDate() == null) {
            return -1;
        }
        return other.getDate().compareTo(this.getDate());
    }
}

