/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.pluginsupport;

import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.pluginsupport.AbstractPlugin;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.Single;
import com.pmease.quickbuild.validation.ValidationException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PluginSettingHelper {
    private static Map<String, Single<Object>> defaultSettings = new ConcurrentHashMap<String, Single<Object>>();

    public static Object getConfigurationSetting(Class<? extends AbstractPlugin> pluginClass, Configuration configuration, boolean interpolate) {
        return PluginManager.instance.getPlugin(pluginClass).getConfigurationSetting(configuration, interpolate);
    }

    public static Object findConfigurationSetting(Class<? extends Plugin> pluginClass, Configuration configuration, boolean interpolate) {
        return PluginManager.instance.getPlugin(pluginClass).findConfigurationSetting(configuration, interpolate);
    }

    public static Object getGroupSetting(Class<? extends AbstractPlugin> pluginClass, Group group, boolean interpolate) {
        return PluginManager.instance.getPlugin(pluginClass).getGroupSetting(group, interpolate);
    }

    public static Object getUserSetting(Class<? extends AbstractPlugin> pluginClass, User user, boolean interpolate) {
        return PluginManager.instance.getPlugin(pluginClass).getUserSetting(user, interpolate);
    }

    public static Object getSetting(Class<? extends AbstractPlugin> pluginClass, boolean interpolate) {
        return PluginManager.instance.getPlugin(pluginClass).getSetting(interpolate);
    }

    public static void saveSetting(Class<? extends AbstractPlugin> pluginClass, Object pluginSetting) {
        PluginManager.instance.getPlugin(pluginClass).saveSetting(pluginSetting);
    }

    public static void saveConfigurationSetting(Class<? extends AbstractPlugin> pluginClass, Configuration configuration, Object pluginSetting) {
        PluginManager.instance.getPlugin(pluginClass).saveConfigurationSetting(configuration, pluginSetting);
    }

    public static void saveUserSetting(Class<? extends AbstractPlugin> pluginClass, User user, Object pluginSetting) {
        PluginManager.instance.getPlugin(pluginClass).saveUserSetting(user, pluginSetting);
    }

    public static void saveGroupSetting(Class<? extends AbstractPlugin> pluginClass, Group group, Object pluginSetting) {
        PluginManager.instance.getPlugin(pluginClass).saveGroupSetting(group, pluginSetting);
    }

    public static Object getDefaultSetting(Class<?> settingClass) {
        Single<Object> wrapped = defaultSettings.get(settingClass.getName());
        if (wrapped == null) {
            try {
                Object defaultSetting = settingClass.newInstance();
                BeanUtils.validate(defaultSetting);
                wrapped = new Single(defaultSetting);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ValidationException e) {
                wrapped = new Single<Object>(null);
            }
            defaultSettings.put(settingClass.getName(), wrapped);
        }
        return wrapped.getValue();
    }
}

