/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.pluginsupport;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.pmease.quickbuild.bootstrap.BootstrapUtils;
import com.pmease.quickbuild.pluginsupport.AbstractPlugin;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.DependencyHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Singleton
public class DefaultPluginManager
implements PluginManager {
    private final Map<String, AbstractPlugin> pluginMap = new LinkedHashMap<String, AbstractPlugin>();

    @Inject
    public DefaultPluginManager(Set<AbstractPlugin> plugins) {
        for (AbstractPlugin plugin : plugins) {
            this.pluginMap.put(plugin.getId(), plugin);
        }
        for (AbstractPlugin plugin : DependencyHelper.sortDependencies(this.pluginMap)) {
            this.pluginMap.remove(plugin.getId());
            this.pluginMap.put(plugin.getId(), plugin);
        }
    }

    @Override
    public void start() {
        for (AbstractPlugin plugin : this.pluginMap.values()) {
            try {
                plugin.start(null);
            }
            catch (Exception e) {
                throw BootstrapUtils.wrapAsUnchecked((Throwable)e);
            }
        }
    }

    @Override
    public void stop() {
        ArrayList<AbstractPlugin> reversed = new ArrayList<AbstractPlugin>(this.pluginMap.values());
        Collections.reverse(reversed);
        for (AbstractPlugin plugin : reversed) {
            try {
                plugin.stop(null);
            }
            catch (Exception e) {
                throw BootstrapUtils.wrapAsUnchecked((Throwable)e);
            }
        }
    }

    @Override
    public <T> List<T> getExtensions(Class<T> extensionPoint) {
        return this.getExtensions(extensionPoint, true);
    }

    @Override
    public <T> List<T> getExtensions(Class<T> extensionPoint, boolean excludeDisabled) {
        ArrayList<T> extensions = new ArrayList<T>();
        for (AbstractPlugin plugin : this.pluginMap.values()) {
            Object[] pluginExtensions;
            if (excludeDisabled && !plugin.isEnabled() || (pluginExtensions = plugin.getExtensions()) == null) continue;
            for (Object extension : pluginExtensions) {
                if (extension == null || !extensionPoint.isAssignableFrom(extension.getClass())) continue;
                extensions.add(extensionPoint.cast(extension));
            }
        }
        return extensions;
    }

    @Override
    public List<Plugin> getPlugins() {
        return new ArrayList<Plugin>(this.pluginMap.values());
    }

    @Override
    public AbstractPlugin getPlugin(Class<? extends Plugin> pluginClass) {
        for (AbstractPlugin plugin : this.pluginMap.values()) {
            if (plugin.getClass() != pluginClass) continue;
            return plugin;
        }
        throw new RuntimeException("Unable to find plugin with class '" + pluginClass + "'.");
    }

    @Override
    public AbstractPlugin getPlugin(String pluginId) {
        if (this.pluginMap.containsKey(pluginId)) {
            return this.pluginMap.get(pluginId);
        }
        throw new RuntimeException("Unable to find plugin with id '" + pluginId + "'.");
    }

    @Override
    public Plugin getDeclaringPlugin(Class<?> clazz) {
        Class<?> unproxied = ClassUtils.unproxy(clazz);
        File classFile = ClassUtils.getClassFile(unproxied);
        for (Plugin plugin : this.getPlugins()) {
            if (!ClassUtils.getClassFile(plugin.getClass()).equals(classFile)) continue;
            return plugin;
        }
        return null;
    }
}

