/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.pluginsupport;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.pmease.quickbuild.pluginsupport.AbstractPlugin;
import com.pmease.quickbuild.util.Dependency;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractPluginModule
extends AbstractModule
implements Dependency {
    private String pluginId;
    private String pluginVersion;
    private String pluginVendor;
    private String pluginName;
    private Set<String> pluginDependencies = new HashSet<String>();

    protected void configure() {
        final Class<? extends AbstractPlugin> pluginClass = this.getPluginClass();
        if (pluginClass != null) {
            Multibinder pluginBinder = Multibinder.newSetBinder((Binder)this.binder(), AbstractPlugin.class);
            pluginBinder.addBinding().to(pluginClass).in(Singleton.class);
            this.bindListener(Matchers.any(), new TypeListener(){

                public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                    if (pluginClass == type.getRawType()) {
                        encounter.register(new InjectionListener<I>(){

                            public void afterInjection(I injectee) {
                                AbstractPlugin plugin = (AbstractPlugin)injectee;
                                plugin.setId(AbstractPluginModule.this.pluginId);
                                plugin.setName(AbstractPluginModule.this.pluginName);
                                plugin.setVendor(AbstractPluginModule.this.pluginVendor);
                                plugin.setVersion(AbstractPluginModule.this.pluginVersion);
                                plugin.setDependencyIds(AbstractPluginModule.this.pluginDependencies);
                            }
                        });
                    }
                }
            });
        }
    }

    protected abstract Class<? extends AbstractPlugin> getPluginClass();

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public void setPluginVendor(String pluginVendor) {
        this.pluginVendor = pluginVendor;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public void setPluginDependencies(Set<String> pluginDependencies) {
        this.pluginDependencies = pluginDependencies;
    }

    @Override
    public String getId() {
        return this.pluginId;
    }

    @Override
    public Set<String> getDependencyIds() {
        return this.pluginDependencies;
    }
}

