/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.pluginsupport;

import com.google.inject.Inject;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.bootstrap.BootstrapUtils;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.entitymanager.GroupManager;
import com.pmease.quickbuild.entitymanager.PluginConfigManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.migration.MigrationListener;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.model.PluginConfig;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginCategory;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.web.page.administration.plugin.AbstractPluginSettingEditPage;
import com.pmease.quickbuild.web.page.administration.plugin.DefaultPluginSettingEditPage;
import com.pmease.quickbuild.web.page.setting.DefaultConfigurationPluginSettingPanel;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.apache.wicket.markup.html.panel.Panel;
import org.osgi.framework.BundleContext;

public abstract class AbstractPlugin
implements Plugin,
Serializable {
    private static final Logger logger = Logger.getLogger(AbstractPlugin.class);
    private String id;
    private String name;
    private String vendor;
    private String version;
    private Set<String> dependencyIds = new HashSet<String>();
    @Inject
    private PluginConfigManager pluginConfigManager;
    @Inject
    private ConfigurationManager configurationManager;
    @Inject
    private UserManager userManager;
    @Inject
    private GroupManager groupManager;
    @Inject
    private ScriptEngine scriptEngine;
    private PluginConfig config;
    private Object configLock = new Object();

    @Override
    public void start(BundleContext context) throws Exception {
        if (Bootstrap.isServer()) {
            boolean needExplicitConfig = this.needExplicitConfig();
            Class<?> settingClass = this.getSettingClass();
            this.config = this.pluginConfigManager.get(this.getId());
            if (this.config == null) {
                this.config = new PluginConfig();
                this.config.setPluginId(this.getId());
                if (settingClass == null) {
                    this.config.setSettingDOM(null);
                    this.config.setEnabled(true);
                } else if (!needExplicitConfig) {
                    this.config.setSettingDOM(VersionedDocument.fromBean(settingClass.newInstance()));
                    this.config.setEnabled(true);
                } else {
                    this.config.setSettingDOM(null);
                    this.config.setEnabled(false);
                    logger.warn((Object)("Plugin '" + this.getId() + "' is not enabled as it needs to be configured."));
                }
            } else if (settingClass == null) {
                if (this.config.getSettingDOM() != null) {
                    this.config.setSettingDOM(null);
                }
            } else if (!needExplicitConfig) {
                if (this.config.getSettingDOM() == null) {
                    try {
                        this.config.setSettingDOM(VersionedDocument.fromBean(settingClass.newInstance()));
                    }
                    catch (Exception e) {
                        throw BootstrapUtils.wrapAsUnchecked((Throwable)e);
                    }
                } else {
                    this.config.getSettingDOM().toBean(null, settingClass);
                }
            } else if (this.config.getSettingDOM() == null) {
                this.config.setEnabled(false);
                logger.warn((Object)("Plugin '" + this.getId() + "' is not enabled as it needs to be configured."));
            } else {
                this.config.getSettingDOM().toBean(null, settingClass);
            }
            this.pluginConfigManager.save(this.config);
        } else {
            this.loadConfig();
        }
    }

    @Override
    public void stop(BundleContext context) throws Exception {
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public final Set<String> getDependencyIds() {
        return Collections.unmodifiableSet(this.dependencyIds);
    }

    public final void setDependencyIds(Set<String> dependencyIds) {
        this.dependencyIds = new HashSet<String>(dependencyIds);
    }

    @Override
    public final Object getSetting(boolean interpolate) {
        Validate.notNull(this.getSettingClass());
        PluginConfig config = this.loadConfig();
        if (config.getSettingDOM() != null) {
            Object setting = config.getSettingDOM().toBean();
            if (interpolate) {
                BeanUtils.validate(setting);
                setting = this.scriptEngine.installInterpolator(setting);
            }
            return setting;
        }
        return null;
    }

    @Override
    public final boolean isEnabled() {
        return this.loadConfig().isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginConfig loadConfig() {
        Object object = this.configLock;
        synchronized (object) {
            if (this.config == null) {
                this.config = this.pluginConfigManager.get(this.getId());
            }
            if (this.config == null) {
                throw new QuickbuildException("Config entry not found for plugin '" + this.getId() + "'.");
            }
            return this.config;
        }
    }

    @Override
    public final void setEnabled(boolean enabled) {
        if (enabled && this.getSettingClass() != null && this.getSetting(false) == null) {
            throw new QuickbuildException("Can not enable plugin as it needs to be configured.");
        }
        PluginConfig config = this.loadConfig();
        config.setEnabled(enabled);
        this.pluginConfigManager.save(config);
        if (enabled) {
            AuditManager.instance.audit("Administration::Plugin", "Plugin '" + this.getName() + "' was enabled.");
        } else {
            AuditManager.instance.audit("Administration::Plugin", "Plugin '" + this.getName() + "' was disabled.");
        }
        this.statusChanged();
    }

    @Override
    public final void saveSetting(Object setting) {
        if (this.getSettingClass() == null) {
            throw new QuickbuildException("This plugin can not be configured.");
        }
        if (this.getSettingClass() != setting.getClass()) {
            throw new QuickbuildException("This plugin expects a setting of type: " + this.getSettingClass().getName());
        }
        PluginConfig config = this.loadConfig();
        boolean settingExistsPreviously = config.getSettingDOM() != null;
        config.setSettingDOM(VersionedDocument.fromBean(setting));
        this.pluginConfigManager.save(config);
        this.settingChanged();
        if (!config.isEnabled() && !settingExistsPreviously) {
            config.setEnabled(true);
            this.pluginConfigManager.save(config);
            this.statusChanged();
        }
    }

    @Override
    public final void saveConfigurationSetting(Configuration configuration, Object pluginSetting) {
        if (pluginSetting != null) {
            configuration.getPluginSettingDOMs().put(this.getId(), VersionedDocument.fromBean(pluginSetting));
        } else {
            configuration.getPluginSettingDOMs().remove(this.getId());
        }
        this.configurationManager.save(configuration);
    }

    @Override
    public final void saveUserSetting(User user, Object pluginSetting) {
        if (pluginSetting != null) {
            user.getPluginSettingDOMs().put(this.getId(), VersionedDocument.fromBean(pluginSetting));
        } else {
            user.getPluginSettingDOMs().remove(this.getId());
        }
        this.userManager.save(user);
    }

    @Override
    public final void saveGroupSetting(Group group, Object pluginSetting) {
        if (pluginSetting != null) {
            group.getPluginSettingDOMs().put(this.getId(), VersionedDocument.fromBean(pluginSetting));
        } else {
            group.getPluginSettingDOMs().remove(this.getId());
        }
        this.groupManager.save(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statusChanged() {
        if (Bootstrap.isServer()) {
            for (GridNode agent : AgentManager.instance.getBuildAgents()) {
                agent.getNodeService().pluginStatusChanged(this.getId());
            }
            for (GridNode agent : AgentManager.instance.getUserAgents()) {
                agent.getNodeService().pluginStatusChanged(this.getId());
            }
        }
        Object object = this.configLock;
        synchronized (object) {
            this.config = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingChanged() {
        if (Bootstrap.isServer()) {
            for (GridNode agent : AgentManager.instance.getBuildAgents()) {
                agent.getNodeService().pluginSettingChanged(this.getId());
            }
            for (GridNode agent : AgentManager.instance.getUserAgents()) {
                agent.getNodeService().pluginSettingChanged(this.getId());
            }
        }
        Object object = this.configLock;
        synchronized (object) {
            this.config = null;
        }
    }

    @Override
    public Class<?> getConfigurationSettingClass() {
        return null;
    }

    @Override
    public Class<?> getGroupSettingClass() {
        return null;
    }

    @Override
    public Class<?> getUserSettingClass() {
        return null;
    }

    @Override
    public final Object getUserSetting(User user, boolean interpolate) {
        Class<?> pluginSettingClass = this.getUserSettingClass();
        if (pluginSettingClass == null) {
            throw new IllegalStateException();
        }
        VersionedDocument dom = user.getPluginSettingDOMs().get(this.getId());
        if (dom != null) {
            Object setting = dom.toBean(new MigrationListener(){

                @Override
                public void afterMigration(Object bean) {
                }
            }, pluginSettingClass);
            if (interpolate && SecurityHelper.isScriptAllowed(user)) {
                setting = this.scriptEngine.installInterpolator(setting);
            }
            return setting;
        }
        return null;
    }

    @Override
    public final Object getConfigurationSetting(Configuration configuration, boolean interpolate) {
        Class<?> pluginSettingClass = this.getConfigurationSettingClass();
        Validate.notNull(pluginSettingClass);
        VersionedDocument dom = configuration.getPluginSettingDOMs().get(this.getId());
        Object setting = dom != null ? dom.toBean(new MigrationListener(){

            @Override
            public void afterMigration(Object bean) {
            }
        }, pluginSettingClass) : (configuration.isRoot() ? PluginSettingHelper.getDefaultSetting(pluginSettingClass) : null);
        if (setting != null && interpolate) {
            setting = this.scriptEngine.installInterpolator(setting);
        }
        return setting;
    }

    @Override
    public final Object getGroupSetting(Group group, boolean interpolate) {
        Class<?> pluginSettingClass = this.getGroupSettingClass();
        Validate.notNull(pluginSettingClass);
        VersionedDocument dom = group.getPluginSettingDOMs().get(this.getId());
        if (dom != null) {
            Object setting = dom.toBean(new MigrationListener(){

                @Override
                public void afterMigration(Object bean) {
                }
            }, pluginSettingClass);
            if (interpolate) {
                setting = this.scriptEngine.installInterpolator(setting);
            }
            return setting;
        }
        return null;
    }

    @Override
    public final Object findConfigurationSetting(Configuration configuration, boolean interpolate) {
        Configuration current = configuration;
        do {
            Object setting;
            if ((setting = this.getConfigurationSetting(current, false)) == ObjectUtils.NULL) {
                return null;
            }
            if (setting == null) continue;
            if (interpolate) {
                setting = this.scriptEngine.installInterpolator(setting);
            }
            return setting;
        } while ((current = current.getParent()) != null);
        return null;
    }

    @Override
    public AbstractPluginSettingEditPage getSettingEditPage() {
        return new DefaultPluginSettingEditPage(this);
    }

    @Override
    public Panel getConfigurationSettingPanel(String panelId) {
        return new DefaultConfigurationPluginSettingPanel(panelId, this);
    }

    public final boolean equals(Object other) {
        if (!(other instanceof Plugin)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Plugin otherPlugin = (Plugin)other;
        return new EqualsBuilder().append((Object)this.getId(), (Object)otherPlugin.getId()).isEquals();
    }

    public final int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getId()).toHashCode();
    }

    private boolean needExplicitConfig() {
        Class<?> settingClass = this.getSettingClass();
        if (settingClass == null) {
            return false;
        }
        return PluginSettingHelper.getDefaultSetting(settingClass) == null;
    }

    @Override
    public abstract Object[] getExtensions();

    @Override
    public Class<?> getSettingClass() {
        return null;
    }

    public String toString() {
        return this.getName() + " (" + this.getVersion() + ")";
    }

    @Override
    public String getClasspath() {
        return ClassUtils.getClassFile(this.getClass()).getAbsolutePath();
    }

    public Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(this.getClass());
    }

    private static Collection<Class<?>> getImplementations() {
        HashSet implementations = new HashSet();
        for (Plugin plugin : PluginManager.instance.getPlugins()) {
            implementations.add(plugin.getClass());
        }
        return implementations;
    }

    @Override
    public PluginCategory getCategory() {
        return PluginCategory.MISC;
    }

    public static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Class<? extends AbstractPlugin> pluginClass;

        public SerializedForm(Class<? extends AbstractPlugin> pluginClass) {
            this.pluginClass = pluginClass;
        }

        public Object readResolve() throws ObjectStreamException {
            return PluginManager.instance.getPlugin(this.pluginClass);
        }
    }
}

