/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.persistence;

import com.pmease.quickbuild.Quickbuild;
import org.hibernate.FlushMode;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;

public class SessionManager {
    private static ThreadLocal<org.hibernate.Session> sessionHolder = new ThreadLocal();
    private static ThreadLocal<Integer> openCountHolder = new ThreadLocal();

    public static org.hibernate.Session getSession() {
        return sessionHolder.get();
    }

    public static void setSession(org.hibernate.Session session) {
        sessionHolder.set(session);
    }

    public static org.hibernate.Session openSession() {
        SessionManager.setOpenCount(SessionManager.getOpenCount() + 1);
        if (SessionManager.getOpenCount() == 1) {
            Session session = Quickbuild.getInstance(SessionFactory.class).openSession();
            session.setFlushMode(FlushMode.MANUAL);
            SessionManager.setSession((org.hibernate.Session)session);
        }
        return SessionManager.getSession();
    }

    public static void closeSession() {
        SessionManager.setOpenCount(SessionManager.getOpenCount() - 1);
        if (SessionManager.getOpenCount() == 0) {
            org.hibernate.Session session = SessionManager.getSession();
            if (session != null) {
                session.close();
            }
            SessionManager.setSession(null);
        }
    }

    private static int getOpenCount() {
        Integer countObj = openCountHolder.get();
        if (countObj == null) {
            return 0;
        }
        return countObj;
    }

    private static void setOpenCount(int count) {
        openCountHolder.set(count);
    }
}

