/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.persistence;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.SessionAware;
import com.pmease.quickbuild.persistence.SessionManager;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.Validate;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionInterceptor
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(SessionInterceptor.class);
    private static ThreadLocal<Session> sessionHolder = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation mi) throws Throwable {
        SessionAware sessionAware = mi.getMethod().getAnnotation(SessionAware.class);
        Validate.notNull((Object)sessionAware);
        Session session = SessionInterceptor.getSession();
        if (session == null) {
            session = SessionManager.getSession();
            if (session == null) {
                session = Quickbuild.getInstance(SessionFactory.class).openSession();
                sessionHolder.set(session);
                try {
                    if (!sessionAware.transactional()) {
                        session.setFlushMode(FlushMode.MANUAL);
                        Object object = mi.proceed();
                        return object;
                    }
                    session.setFlushMode(FlushMode.COMMIT);
                    session.getTransaction().begin();
                    Object result = mi.proceed();
                    session.getTransaction().commit();
                    Object object = result;
                    return object;
                }
                finally {
                    session.close();
                    sessionHolder.set(null);
                }
            }
            sessionHolder.set(session);
            try {
                if (sessionAware.transactional() && !session.getTransaction().isActive()) {
                    try {
                        FlushMode previousMode = session.getFlushMode();
                        session.setFlushMode(FlushMode.COMMIT);
                        session.getTransaction().begin();
                        Object result = mi.proceed();
                        session.getTransaction().commit();
                        session.setFlushMode(previousMode);
                        Object object = result;
                        return object;
                    }
                    catch (Throwable throwable) {
                        try {
                            session.getTransaction().rollback();
                        }
                        catch (Throwable rbex) {
                            logger.error("Error rolling back transaction.", rbex);
                        }
                        throw throwable;
                    }
                }
                Object throwable = mi.proceed();
                return throwable;
            }
            finally {
                sessionHolder.set(null);
            }
        }
        if (sessionAware.transactional() && !session.getTransaction().isActive()) {
            try {
                FlushMode previousMode = session.getFlushMode();
                session.setFlushMode(FlushMode.COMMIT);
                session.getTransaction().begin();
                Object result = mi.proceed();
                session.getTransaction().commit();
                session.setFlushMode(previousMode);
                return result;
            }
            catch (Throwable throwable) {
                try {
                    session.getTransaction().rollback();
                }
                catch (Throwable rbex) {
                    logger.error("Error rolling back transaction.", rbex);
                }
                throw throwable;
            }
        }
        return mi.proceed();
    }

    public static Session getSession() {
        return sessionHolder.get();
    }
}

