/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.persistence;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.persistence.AgentSessionFactory;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.DbUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.HibernateUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.persistence.Entity;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SessionFactoryProvider
implements Provider<SessionFactory> {
    private static final Logger logger = LoggerFactory.getLogger(SessionFactoryProvider.class);
    @Inject
    private NamingStrategy namingStrategy;
    private boolean created = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionFactory get() {
        if (Bootstrap.isServer()) {
            Configuration configuration = new Configuration();
            Collection<Class<?>> implementations = ClassUtils.findImplementations(AbstractEntity.class, AbstractEntity.class);
            for (Class<?> implementation : implementations) {
                if (implementation.getAnnotation(Entity.class) == null) continue;
                configuration.addAnnotatedClass(implementation);
            }
            configuration.setNamingStrategy(this.namingStrategy);
            Properties props = HibernateUtils.loadProps();
            if (Bootstrap.bootAction != null) {
                props.setProperty("hibernate.connection.provider_class", "com.pmease.quickbuild.persistence.SimpleConnectionProvider");
            }
            if (DbUtils.isPostgreSQL()) {
                props.setProperty("hibernate.connection.autocommit", "false");
            }
            if (DbUtils.isH2()) {
                logger.warn("Embedded H2 database is used and connection pool size is limited to 1 for stability reason. For production usage, please switch to an external database.");
                props.setProperty("hibernate.c3p0.min_size", "1");
                props.setProperty("hibernate.c3p0.max_size", "1");
            }
            props.remove("hibernate.hbm2ddl.auto");
            configuration.setProperties(props);
            if (DbUtils.getDataVersion() == null) {
                File tempFile = FileUtils.createTempFile("sessionfactory");
                try {
                    new SchemaExport(configuration).setOutputFile(tempFile.getAbsolutePath()).setFormat(false).create(false, false);
                    ArrayList<String> sqls = new ArrayList<String>();
                    boolean start = false;
                    for (String sql : FileUtils.readFileAsLines(tempFile)) {
                        if (sql.startsWith("create table")) {
                            start = true;
                        }
                        if (!start || sql.toLowerCase().contains("ifk_") && (DbUtils.isMySQL() || DbUtils.isH2())) continue;
                        sqls.add(sql);
                    }
                    if (DbUtils.isMySQL()) {
                        sqls.add("ALTER TABLE QB_CONFIGURATION ROW_FORMAT = COMPRESSED;");
                    }
                    DbUtils.execute(sqls);
                }
                finally {
                    tempFile.delete();
                }
            }
            this.created = true;
            return configuration.buildSessionFactory();
        }
        return new AgentSessionFactory();
    }

    public boolean isCreated() {
        return this.created;
    }
}

