/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.persistence;

import org.hibernate.AssertionFailure;
import org.hibernate.cfg.ImprovedNamingStrategy;
import org.hibernate.util.StringHelper;

public class PersistenceNamingStrategy
extends ImprovedNamingStrategy {
    private static final String PREFIX = "QB";

    public String classToTableName(String className) {
        return "QB_" + PersistenceNamingStrategy.addUnderscores((String)StringHelper.unqualify((String)className)).toUpperCase();
    }

    public String propertyToColumnName(String propertyName) {
        return "QB_" + PersistenceNamingStrategy.addUnderscores((String)StringHelper.unqualify((String)propertyName)).toUpperCase();
    }

    public String logicalCollectionColumnName(String columnName, String propertyName, String referencedColumn) {
        if ((this.propertyToColumnName(propertyName) + "_" + referencedColumn.toUpperCase()).equalsIgnoreCase(columnName)) {
            return StringHelper.unqualify((String)propertyName);
        }
        return StringHelper.isNotEmpty((String)columnName) ? columnName : StringHelper.unqualify((String)propertyName);
    }

    public String foreignKeyColumnName(String propertyName, String propertyEntityName, String propertyTableName, String referencedColumnName) {
        String header;
        String string = header = propertyName != null ? StringHelper.unqualify((String)propertyName) : propertyTableName;
        if (header == null) {
            throw new AssertionFailure("NamingStrategy not properly filled");
        }
        return "QB_" + this.columnName(header).toUpperCase() + "_" + referencedColumnName.toUpperCase();
    }
}

