/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.persistence;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.persistence.AgentSession;
import com.pmease.quickbuild.persistence.UnsupportedAgentOperationException;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.Pair;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.util.SerializationHelper;

public class AgentQueryCarrier
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private AgentSession agentSession;
    private Object collection;
    private final String queryString;
    private List<MethodCall> methodCalls = new ArrayList<MethodCall>();

    public AgentQueryCarrier(AgentSession agentSession, String queryString) {
        this.agentSession = agentSession;
        this.queryString = queryString;
    }

    public AgentQueryCarrier(AgentSession agentSession, Object collection, String queryString) {
        this.agentSession = agentSession;
        this.collection = collection;
        this.queryString = queryString;
    }

    public Query createQueryProxy() {
        return (Query)Proxy.newProxyInstance(Query.class.getClassLoader(), new Class[]{Query.class}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().startsWith("set")) {
            this.methodCalls.add(new MethodCall(method.getName(), method.getParameterTypes(), args));
            return proxy;
        }
        if (method.getName().equals("list")) {
            return SerializationHelper.deserialize(Quickbuild.getServerService().queryList(SerializationHelper.serialize(this)));
        }
        if (method.getName().equals("executeUpdate")) {
            return Quickbuild.getServerService().executeUpdate(SerializationHelper.serialize(this));
        }
        if (method.getName().equals("uniqueResult")) {
            return SerializationHelper.deserialize(Quickbuild.getServerService().queryUniqueResult(SerializationHelper.serialize(this)));
        }
        throw new UnsupportedAgentOperationException();
    }

    public Query assembleQuery(Session session) {
        for (Pair<Object, LockOptions> each : this.agentSession.getLockedObjects()) {
            session.buildLockRequest(each.getSecond()).lock(each.getFirst());
        }
        Query query = this.collection != null ? session.createFilter(this.collection, this.queryString) : session.createQuery(this.queryString);
        for (MethodCall methodCall : this.methodCalls) {
            try {
                Method method = query.getClass().getMethod(methodCall.getMethodName(), methodCall.getParamTypes());
                method.invoke((Object)query, methodCall.getParamValues());
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
        return query;
    }

    private static class MethodCall
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String methodName;
        private Class<?>[] paramTypes;
        private Object[] paramValues;

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public Class<?>[] getParamTypes() {
            return this.paramTypes;
        }

        public void setParamTypes(Class<?>[] paramTypes) {
            this.paramTypes = paramTypes;
        }

        public Object[] getParamValues() {
            return this.paramValues;
        }

        public void setParamValues(Object[] paramValues) {
            this.paramValues = paramValues;
        }

        public MethodCall(String methodName, Class<?>[] paramTypes, Object[] paramValues) {
            this.methodName = methodName;
            this.paramTypes = paramTypes;
            this.paramValues = paramValues;
        }
    }
}

