/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.persistence;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.persistence.AgentSession;
import com.pmease.quickbuild.persistence.UnsupportedAgentOperationException;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.Pair;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.util.SerializationHelper;

public class AgentCriteriaCarrier
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private AgentSession agentSession;
    private final Class<?> entityClass;
    private final String entityName;
    private final String alias;
    private List<MethodCall> methodCalls = new ArrayList<MethodCall>();

    public AgentCriteriaCarrier(AgentSession agentSession, Class<?> entityClass) {
        this.agentSession = agentSession;
        this.entityClass = entityClass;
        this.entityName = null;
        this.alias = null;
    }

    public AgentCriteriaCarrier(AgentSession agentSession, String entityName) {
        this.agentSession = agentSession;
        this.entityName = entityName;
        this.entityClass = null;
        this.alias = null;
    }

    public AgentCriteriaCarrier(AgentSession agentSession, Class<?> entityClass, String alias) {
        this.agentSession = agentSession;
        this.entityClass = entityClass;
        this.alias = alias;
        this.entityName = null;
    }

    public AgentCriteriaCarrier(AgentSession agentSession, String entityName, String alias) {
        this.agentSession = agentSession;
        this.entityName = entityName;
        this.alias = alias;
        this.entityClass = null;
    }

    public Criteria createCriteriaProxy() {
        return (Criteria)Proxy.newProxyInstance(Criteria.class.getClassLoader(), new Class[]{Criteria.class}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("list")) {
            return SerializationHelper.deserialize(Quickbuild.getServerService().criteriaList(SerializationHelper.serialize(this)));
        }
        if (method.getName().equals("uniqueResult")) {
            return SerializationHelper.deserialize(Quickbuild.getServerService().criteriaUniqueResult(SerializationHelper.serialize(this)));
        }
        if (method.getName().startsWith("set") || method.getName().startsWith("add") || method.getName().startsWith("create")) {
            this.methodCalls.add(new MethodCall(method.getName(), method.getParameterTypes(), args));
            return proxy;
        }
        throw new UnsupportedAgentOperationException();
    }

    public Criteria assembleCriteria(Session session) {
        for (Pair<Object, LockOptions> each : this.agentSession.getLockedObjects()) {
            session.buildLockRequest(each.getSecond()).lock(each.getFirst());
        }
        Criteria criteria = this.alias != null ? (this.entityClass != null ? session.createCriteria(this.entityClass, this.alias) : session.createCriteria(this.entityName, this.alias)) : (this.entityClass != null ? session.createCriteria(this.entityClass) : session.createCriteria(this.entityName));
        for (MethodCall methodCall : this.methodCalls) {
            try {
                Method method = criteria.getClass().getMethod(methodCall.getMethodName(), methodCall.getParamTypes());
                criteria = (Criteria)method.invoke((Object)criteria, methodCall.getParamValues());
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
        return criteria;
    }

    private static class MethodCall
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String methodName;
        private Class<?>[] paramTypes;
        private Object[] paramValues;

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public Class<?>[] getParamTypes() {
            return this.paramTypes;
        }

        public void setParamTypes(Class<?>[] paramTypes) {
            this.paramTypes = paramTypes;
        }

        public Object[] getParamValues() {
            return this.paramValues;
        }

        public void setParamValues(Object[] paramValues) {
            this.paramValues = paramValues;
        }

        public MethodCall(String methodName, Class<?>[] paramTypes, Object[] paramValues) {
            this.methodName = methodName;
            this.paramTypes = paramTypes;
            this.paramValues = paramValues;
        }
    }
}

