/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Dashboard;
import com.pmease.quickbuild.model.User;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;

@Entity
@ScriptApi
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"user", "dashboard"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class UserShare
extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=false)
    @ForeignKey(name="FK_SHARE_USER")
    @Index(name="IFK_SHARE_USER")
    private User user;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=false)
    @ForeignKey(name="FK_U_SHARE_DASH")
    @Index(name="IFK_U_SHARE_DASH")
    private Dashboard dashboard;

    @ScriptApi
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @ScriptApi
    public Dashboard getDashboard() {
        return this.dashboard;
    }

    public void setDashboard(Dashboard dashboard) {
        this.dashboard = dashboard;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof UserShare)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        UserShare otherShare = (UserShare)other;
        return new EqualsBuilder().append((Object)this.getUser().getId(), (Object)otherShare.getUser().getId()).append((Object)this.getDashboard().getId(), (Object)otherShare.getDashboard().getId()).isEquals();
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 37);
        if (this.getUser() != null) {
            builder.append((Object)this.getUser().getId());
        }
        if (this.getDashboard() != null) {
            builder.append((Object)this.getDashboard().getId());
        }
        return builder.toHashCode();
    }
}

