/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Name;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.entitymanager.SettingManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Alarm;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.BuildOption;
import com.pmease.quickbuild.model.Dashboard;
import com.pmease.quickbuild.model.Membership;
import com.pmease.quickbuild.model.PromoteOption;
import com.pmease.quickbuild.model.Subscription;
import com.pmease.quickbuild.model.UserShare;
import com.pmease.quickbuild.security.Authenticator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@ScriptApi
public class User
extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    public static final Long ROOT_ID = 1L;
    @OneToMany(mappedBy="user")
    private Collection<Membership> memberships;
    @OneToMany(mappedBy="user")
    private Collection<Dashboard> dashboards;
    @OneToMany(mappedBy="user")
    private Collection<UserShare> shares;
    @Column(length=16384)
    @Lob
    private ArrayList<Long> favoriteDashboardIds;
    @Column(unique=true, nullable=false)
    private String name;
    private String fullName;
    private String email;
    private String authenticator;
    private SearchFor searchFor;
    @Column(nullable=false)
    private String password;
    @Column(nullable=false, length=65535)
    @Lob
    private HashMap<String, VersionedDocument> pluginSettingDOMs = new HashMap();
    @OneToMany(mappedBy="requester")
    private Collection<Build> requestedBuilds;
    @OneToMany(mappedBy="canceller")
    private Collection<Build> cancelledBuilds;
    @OneToMany(mappedBy="user", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Collection<Subscription> subscriptions;
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Collection<BuildOption> buildOptions;
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Collection<PromoteOption> promoteOptions;
    @OneToMany(mappedBy="user", cascade={CascadeType.REMOVE})
    private Collection<Alarm> alarms;

    @Editable(order=100, name="Login Name")
    @NotEmpty
    @Name
    @ScriptApi(value="Get name of the user.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Editable(order=150, name="Login Password")
    @Password(confirmative=true)
    @NotEmpty
    @ScriptApi(value="Get password of the user.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Editable(order=200)
    @ScriptApi(value="Get full name of the user. <em>null</em> will be returned if full name is not specified.")
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Editable(order=300)
    @Email
    @ScriptApi(value="Get Email of the user. <em>null</em> will be returned if Email is not specified.")
    @Scriptable
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Editable(order=400, description="Optionally specify the authenticator used for this user.")
    @ChoiceProvider(value="getAuthenticatorChoices")
    public String getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(String authenticator) {
        this.authenticator = authenticator;
    }

    public SearchFor getSearchFor() {
        if (this.searchFor == null) {
            this.searchFor = SearchFor.CONFIGURATIONS;
        }
        return this.searchFor;
    }

    public void setSearchFor(SearchFor searchFor) {
        this.searchFor = searchFor;
    }

    private static List<String> getAuthenticatorChoices() {
        ArrayList<String> authenticatorNames = new ArrayList<String>();
        SettingManager settingManager = Quickbuild.getInstance(SettingManager.class);
        for (Authenticator authenticator : settingManager.getSecuritySetting().getAuthenticators(false)) {
            authenticatorNames.add(authenticator.getName());
        }
        return authenticatorNames;
    }

    public HashMap<String, VersionedDocument> getPluginSettingDOMs() {
        return this.pluginSettingDOMs;
    }

    public void setPluginSettingDOMs(HashMap<String, VersionedDocument> pluginSettingDOMs) {
        this.pluginSettingDOMs = pluginSettingDOMs;
    }

    @ScriptApi(value="Get memberships of an user")
    public Collection<Membership> getMemberships() {
        if (this.memberships == null) {
            this.memberships = new ArrayList<Membership>();
        }
        return this.memberships;
    }

    public void setMemberships(Collection<Membership> memberships) {
        this.memberships = memberships;
    }

    public Collection<Dashboard> getDashboards() {
        if (this.dashboards == null) {
            this.dashboards = new ArrayList<Dashboard>();
        }
        return this.dashboards;
    }

    public void setDashboards(Collection<Dashboard> dashboards) {
        this.dashboards = dashboards;
    }

    public Collection<UserShare> getShares() {
        if (this.shares == null) {
            this.shares = new ArrayList<UserShare>();
        }
        return this.shares;
    }

    public void setShares(Collection<UserShare> shares) {
        this.shares = shares;
    }

    public Collection<Build> getRequestedBuilds() {
        if (this.requestedBuilds == null) {
            this.requestedBuilds = new ArrayList<Build>();
        }
        return this.requestedBuilds;
    }

    public void setBuilds(Collection<Build> builds) {
        this.requestedBuilds = builds;
    }

    public Collection<Build> getCancelledBuilds() {
        if (this.cancelledBuilds == null) {
            this.cancelledBuilds = new ArrayList<Build>();
        }
        return this.cancelledBuilds;
    }

    public void setCancelledBuilds(Collection<Build> cancelledBuilds) {
        this.cancelledBuilds = cancelledBuilds;
    }

    @Editable(order=500)
    public Collection<Subscription> getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<Subscription>();
        }
        return this.subscriptions;
    }

    public void setSubscriptions(Collection<Subscription> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public Collection<BuildOption> getBuildOptions() {
        if (this.buildOptions == null) {
            this.buildOptions = new ArrayList<BuildOption>();
        }
        return this.buildOptions;
    }

    public void setBuildOptions(Collection<BuildOption> buildOptions) {
        this.buildOptions = buildOptions;
    }

    public Collection<PromoteOption> getPromoteOptions() {
        if (this.promoteOptions == null) {
            this.promoteOptions = new ArrayList<PromoteOption>();
        }
        return this.promoteOptions;
    }

    public void setPromoteOptions(Collection<PromoteOption> promoteOptions) {
        this.promoteOptions = promoteOptions;
    }

    public Collection<Alarm> getAlarms() {
        if (this.alarms == null) {
            this.alarms = new ArrayList<Alarm>();
        }
        return this.alarms;
    }

    public void setAlarms(Collection<Alarm> alarms) {
        this.alarms = alarms;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof User)) {
            return false;
        }
        User otherUser = (User)other;
        return new EqualsBuilder().append((Object)this.getName(), (Object)otherUser.getName()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getName()).toHashCode();
    }

    @ScriptApi(value="Whether or not this is the root user.")
    public boolean isRoot() {
        return this.getId().equals(ROOT_ID);
    }

    public Set<String> getGroupNames() {
        HashSet<String> groupNames = new HashSet<String>();
        for (Membership membership : this.getMemberships()) {
            groupNames.add(membership.getGroup().getName());
        }
        return groupNames;
    }

    @ScriptApi(value="Get display name of the user. Display name will be the same as full name if full name is specified; otherwise, the login name will be used.")
    public String getDisplayName() {
        if (this.getFullName() != null) {
            return this.getFullName();
        }
        return this.getName();
    }

    public Dashboard getDashboard(String name) {
        for (Dashboard dashboard : this.getDashboards()) {
            if (!dashboard.getName().equals(name)) continue;
            return dashboard;
        }
        return null;
    }

    public List<Long> getFavoriteDashboardIds() {
        if (this.favoriteDashboardIds == null) {
            this.favoriteDashboardIds = new ArrayList();
        }
        return this.favoriteDashboardIds;
    }

    public static enum SearchFor {
        CONFIGURATIONS,
        BUILDS;

    }
}

