/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.CloudProfile;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"ip", "port"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@ScriptApi(value="This class represents assigned grid token which can be used by build agent to access grid.")
public class Token
extends AbstractEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(unique=true, nullable=false)
    private String value;
    private String ip;
    private int port;
    private boolean test;
    private String nodeLaunchId;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=true)
    @Index(name="IFK_TOKEN_PROFILE")
    @ForeignKey(name="FK_TOKEN_PROFILE")
    private CloudProfile cloudProfile;
    @Column(nullable=false)
    private String hostName;
    private boolean offlineAlert = true;

    @ScriptApi(value="Get value of this token.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @ScriptApi(value="Get ip address associated with this token. Null if there is no ip associated with this token.")
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isTest() {
        return this.test;
    }

    public void setTest(boolean test) {
        this.test = test;
    }

    public CloudProfile getCloudProfile() {
        return this.cloudProfile;
    }

    public void setCloudProfile(CloudProfile cloudProfile) {
        this.cloudProfile = cloudProfile;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getAddress() {
        return this.getHostName() + ":" + this.port;
    }

    public String getNodeLaunchId() {
        return this.nodeLaunchId;
    }

    public void setNodeLaunchId(String nodeLaunchId) {
        this.nodeLaunchId = nodeLaunchId;
    }

    public boolean isOfflineAlert() {
        return this.offlineAlert;
    }

    public void setOfflineAlert(boolean offlineAlert) {
        this.offlineAlert = offlineAlert;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Token)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Token otherToken = (Token)other;
        return new EqualsBuilder().append((Object)this.value, (Object)otherToken.getValue()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getValue()).toHashCode();
    }
}

